<?php

use Timber\Menu as TimberMenu;
use Timber\Site as TimberSite;
use Timber\Timber;


if (!class_exists('Timber\Timber')) {
    add_action('admin_notices', function () {
        echo '<div class="error"><p>amadeus CORE not activated. Make sure you activate the plugin in <a href="' . esc_url(admin_url('plugins.php#timber')) . '">' . esc_url(admin_url('plugins.php')) . '</a></p></div>';
    });

    add_filter('template_include', function ($template) {
        return get_stylesheet_directory() . '/static/no-timber.html';
    });

    return;
}

Timber::$dirname = array('views');

class JacobBaumannSite extends TimberSite
{

    protected $themeSlug = 'jacob-baumann';

    function __construct()
    {
        add_theme_support('post-formats', array('aside', 'gallery', 'status', 'video'));
        add_theme_support('post-thumbnails');
        add_theme_support('menus');
        add_theme_support('automatic-feed-links');
        add_theme_support('html5', array('comment-list', 'comment-form', 'search-form', 'gallery', 'caption'));
        add_theme_support('title-tag');
        add_theme_support('customize-selective-refresh-widgets');
        add_theme_support('gutenberg');


        add_filter('timber_context', array($this, 'add_to_context'));
//		add_filter( 'get_twig', array( $this, 'add_to_twig' ) );
//		add_action( 'init', array( $this, 'register_post_types' ) );
//		add_action( 'init', array( $this, 'register_taxonomies' ) );
        #

        add_action('wp_enqueue_scripts', [$this, 'registerScripts'], 1, 1);
        add_action('wp_enqueue_scripts', [$this, 'registerStyles'], 2, 13);
        add_action('admin_enqueue_scripts', [$this, 'registerAdminScripts'],999,0);


        add_filter( 'style_loader_src', [$this,'removeVersion'], 9999 );
        add_filter( 'script_loader_src', [$this,'removeVersion'], 9999 );

        add_action('init', [$this, 'gutenberg_boilerplate_block']);


        $this->addUpdater();


        parent::__construct();
    }


    function gutenberg_boilerplate_block()
    {
        wp_register_script(
            'gutenberg-boilerplate-es5-step01',
            get_stylesheet_directory_uri() . '/blocks/step-01/block.js',
            ['wp-blocks', 'wp-element']
        );

        register_block_type('gutenberg-boilerplate-es5/hello-world-step-01', [
            'editor_script' => 'gutenberg-boilerplate-es5-step01',
        ]);
    }


    function add_to_context($context)
    {

        $context['primary'] = new TimberMenu('primary');
        $context['footer'] = new TimberMenu('footer');
        $context['site'] = $this;
        $context['currentBlogId'] = get_current_blog_id();
        return $context;
    }

    function myfoo($text)
    {

        return $text;
    }

    function add_to_twig($twig)
    {
        /* this is where you can add your own functions to twig */
        $twig->addExtension(new Twig_Extension_StringLoader());

        return $twig;
    }

    function addUpdater()
    {

        $myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
            'https://updates.amadeus-agentur.com/?action=get_metadata&slug=' . $this->themeSlug,
            __FILE__, //Full path to the main plugin file or functions.php.
            $this->themeSlug
        );
    }

    public function registerAdminScripts()
    {
//        wp_deregister_script('jquery');
//        wp_enqueue_script('jquery', 'https://ajax.googleapis.com/ajax/libs/jquery/3.1.1/jquery.min.js', array(), null, false);

        wp_enqueue_style('z-amds-style', get_stylesheet_directory_uri() . '/static/css/jb-admin.css', [], wp_get_theme()->get('Version'));

    }

    public function registerScripts()
    {

        wp_enqueue_script('app', get_stylesheet_directory_uri() . '/static/js/app.js', [], wp_get_theme()->get('Version'), true);


    }

    public function registerStyles()
    {

        #wp_enqueue_style('style', get_stylesheet_directory_uri() . '/static/css/jacob-baumann.css', ['wp-block-library'], wp_get_theme()->get('Version'));
        wp_enqueue_style('style', get_stylesheet_directory_uri() . '/static/css/jacob-baumann.css', ['wp-block-library']);
    }

    function removeVersion( $src ) {
        if ( strpos( $src, 'ver=' . get_bloginfo( 'version' ) ) )
            $src = remove_query_arg( 'ver', $src );
        return $src;
    }

}

include 'updater/theme-updater.php';

new JacobBaumannSite();
