/* File: gulpfile.js */


// grab our gulp packages
var gulp = require('gulp'),
    babel = require('gulp-babel'),
    del = require('del'),
    browser = require('browser-sync'),
    gulpif = require('gulp-if'),
    log = require('fancy-log'),
    autoprefixer = require('gulp-autoprefixer'),
    concat = require('gulp-concat'),
    cleanCSS = require('gulp-clean-css'),
    sass = require('gulp-sass')(require('sass')),
    rename = require('gulp-rename'),
    sourcemaps = require('gulp-sourcemaps'),
    uglify = require('gulp-uglify'),
    webpack = require('webpack-stream'),
    plumber = require('gulp-plumber')




// environmental settings for production/deployment

var $isProduction = (process.argv[3] == "--production"),
    $environment = (process.argv[4] == "--live" ? 'https://jb-werkzeugbau.de' : 'http://jb.dev.amadeus-agentur.com');


var isProduction = false,
    sourceMap = true,
    deployDev = true,
    deployLive = false;

if ($isProduction) {
    isProduction = true;
    sourceMap = false;
    deployDev = true;
    deployLive = true;
}


function clean(done) {
    del([
        'theme/static/css/**/*',
        // '/theme/static/js/**/*'
    ], {
        force: true
    });
    done();
}


// Less to CSS: Run manually with: "gulp build-css"
function stylesheet() {
    return gulp.src(['theme/assets/scss/theme.scss'])
        .pipe(gulpif(!$isProduction, sourcemaps.init()))
        .pipe(sass({
            includePaths: ['./node_modules/']
        }).on('error', sass.logError))

        .pipe(autoprefixer({
            browsers: ['>1% in DE']
        }))
        .pipe(cleanCSS({
                level: 1,
                format: (!$isProduction ? 'beautify' : 'none'),
            }, function (details) {
                console.log(details.name + ': ' + (details.stats.originalSize / 1024).toFixed(2) + '/' + (details.stats.minifiedSize / 1024).toFixed(2) + ' KB' + ' (-' + (details.stats.efficiency * 100).toFixed(2) + '%)')
            }
        ))
        .pipe(gulpif(!$isProduction, sourcemaps.write()))
        .pipe(rename('jacob-baumann.css'))

        .pipe(gulp.dest('theme/static/css/'))

        .pipe(browser.reload({stream: true}));
}



function server(done) {
    browser.init({
        open: false,
        // online: true,
        // reloadOnRestart: true,
        // logConnections: true,
        proxy: $environment,
        https: false,
        // injectCss: true,
        serveStatic: [{
            route: 'app/themes/jacob-baumann/static',
            dir: 'theme/static'
        }],
        notify: {
            styles: {
                top: 'auto',
                bottom: '0',
                borderRadius: '5px 0px 0px'
            }
        }
    });
    done();
}


function watch() {
    gulp.watch('theme/assets/scss/**/*.scss').on('all', gulp.series(stylesheet));
    // gulp.watch('../Resources/Private/JavaScript/**/*.js').on('all', gulp.series(jsLibs, jsBootstrap, browser.reload));
}


// Build the "dist" folder by running all of the below tasks
gulp.task('build',
    gulp.series(clean, gulp.parallel(stylesheet))
);

// Build the site, run the server, and watch for file changes
gulp.task('default',
    gulp.series('build', server, watch)
);
