<?php
return [
	'ctrl' => [
		'title'	=> 'LLL:EXT:indikationstabelle/Resources/Private/Language/locallang_db.xlf:tx_indikationstabelle_domain_model_produkt',
		'label' => 'proname',
		'tstamp' => 'tstamp',
		'crdate' => 'crdate',
		'cruser_id' => 'cruser_id',
		'dividers2tabs' => TRUE,
		'versioningWS' => 2,
		'versioning_followPages' => TRUE,
        'sortby' => 'sorting',
		'languageField' => 'sys_language_uid',
		'transOrigPointerField' => 'l10n_parent',
		'transOrigDiffSourceField' => 'l10n_diffsource',
		'delete' => 'deleted',
		'enablecolumns' => [
			'disabled' => 'hidden',
			'starttime' => 'starttime',
			'endtime' => 'endtime',
        ],
		'searchFields' => '',
		'iconfile' => 'EXT:indikationstabelle/Resources/Public/Icons/tx_indikationstabelle_domain_model_produkt.gif'
	],
	'interface' => [
		'showRecordFieldList' => 'proname, icon, artno, artdescr, product_page_id, sys_language_uid, l10n_parent, l10n_diffsource, hidden ',
    ],
	'types' => [
		'1' => [
            'showitem' => 'proname, icon, artno, artdescr, product_page_id, sys_language_uid;;;;1-1-1, l10n_parent,  l10n_diffsource, hidden;;1, --div--;LLL:EXT:cms/locallang_ttc.xlf:tabs.access, starttime, endtime'
        ],
	],
	'palettes' => [
		'1' => [
            'showitem' => ''
        ],
	],
	'columns' => [
        'proname' => [
            'label' => 'Name',
            'config' => [
                'type' => 'input',
                'size' => '40',
                'eval' => 'trim',
                'max' => '255'
            ]
        ],
	    'sys_language_uid' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.language',
			'config' => [
				'type' => 'select',
                'renderType' => 'selectSingle',
				'foreign_table' => 'sys_language',
				'foreign_table_where' => 'ORDER BY sys_language.title',
				'items' => [
					array('LLL:EXT:lang/locallang_general.xlf:LGL.allLanguages', -1),
					array('Default', 0)
                ]
            ]
        ],
		'l10n_parent' => [
			'displayCond' => 'FIELD:sys_language_uid:>:0',
			'exclude' => 1,
			'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.l18n_parent',
			'config' => [
				'type' => 'select',
                'renderType' => 'selectSingle',
				'items' => [
					array('', 0),
				],
				'foreign_table' => 'tx_indikationstabelle_domain_model_produkt',
				'foreign_table_where' => 'AND tx_indikationstabelle_domain_model_produkt.pid=###CURRENT_PID### AND tx_indikationstabelle_domain_model_produkt.sys_language_uid IN (-1,0)',
            ]
        ],
		'l10n_diffsource' => [
			'config' => [
				'type' => 'passthrough',
            ]
        ],
		't3ver_label' => [
			'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.versionLabel',
			'config' => [
				'type' => 'input',
				'size' => 30,
				'max' => 255,
            ]
        ],
        'icon' => [
            'label' => 'Icon',
            'config' => [
                'type' => 'input',
                'size' => '40',
                'eval' => 'trim',
                'max' => '255'
            ],
            'l10n_mode' => 'exclude'
        ],
        'artno' => [
            'label' => 'Artikelnummer',
            'config' => [
                'type' => 'input',
                'size' => '40',
                'eval' => 'trim',
                'max' => '319'
            ],
            'l10n_mode' => 'exclude'
        ],
        'artdescr' => [
            'label' => 'Artikelbeschreibung',
            'config' => [
                'type' => 'input',
                'size' => '40',
                'eval' => 'trim',
                'max' => '255'
            ]
        ],
        'product_page_id'=> [
            'label' => 'Produktseiten ID',
            'config' => [
                'type' => 'input',
                'size' => '40',
                'eval' => 'trim',
                'max' => '255'
            ],
            'l10n_mode' => 'exclude'
        ],
		'hidden' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.hidden',
			'config' => [
				'type' => 'check',
            ]
        ],
		'starttime' => [
			'exclude' => 1,
			'l10n_mode' => 'mergeIfNotBlank',
			'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.starttime',
			'config' => [
				'type' => 'input',
				'size' => 13,
				'max' => 20,
				'eval' => 'datetime',
				'checkbox' => 0,
				'default' => 0,
				'range' => [
					'lower' => mktime(0, 0, 0, date('m'), date('d'), date('Y'))
                ]
            ]
        ],
		'endtime' => [
			'exclude' => 1,
			'l10n_mode' => 'mergeIfNotBlank',
			'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.endtime',
			'config' => [
				'type' => 'input',
				'size' => 13,
				'max' => 20,
				'eval' => 'datetime',
				'checkbox' => 0,
				'default' => 0,
				'range' => [
					'lower' => mktime(0, 0, 0, date('m'), date('d'), date('Y'))
				]
            ],
        ],
    ],
];
