<?php
namespace AmadeusAgentur\Indikationstabelle\Domain\Model;


    /***************************************************************
     *
     *  Copyright notice
     *
     *  (c) 2016 Jan-Frederic Schubert <jan-frederic.schubert@amadeus-agentur.com>, Amadeus Agentur
     *
     *  All rights reserved
     *
     *  This script is part of the TYPO3 project. The TYPO3 project is
     *  free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 3 of the License, or
     *  (at your option) any later version.
     *
     *  The GNU General Public License can be found at
     *  http://www.gnu.org/copyleft/gpl.html.
     *
     *  This script is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  This copyright notice MUST APPEAR in all copies of the script!
     ***************************************************************/

/**
 * Produkt
 *
 */
class Produkt extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{


    /** proname
     * @var string
     */
    protected $proname;

     /** icon
     * @var string
     */
    protected $icon;

    /** artno
     * @var string
     */
    protected $artno;


    /** artdescr
     * @var string
     */
    protected $artdescr;


    /** product_page_id
     * @var integer
     */
    protected $product_page_id;

    public function __construct($proname, $filter, $icon,$artno,$artdescr)
    {
        $this->setProname($proname);
        $this->setIndikationstabelleFilter($filter);
        $this->setIcon($icon);
        $this->setArtno($artno);
        $this->setAA($artno);
    }

    /**
     * @return mixed
     */
    public function getProname()
    {
        return $this->proname;
    }

    /**
     * @param mixed $proname
     */
    public function setProname($proname)
    {
        $this->proname = $proname;
    }



    /**
     * @return mixed
     */
    public function getIcon()
    {
        return $this->icon;
    }

    /**
     * @param mixed $icon
     */
    public function setIcon($icon)
    {
        $this->icon = $icon;
    }


    /**
     * indikationstabelle_filter
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\AmadeusAgentur\Indikationstabelle\Domain\Model\Category>
     */
    protected $indikationstabelle_filter;

    /**
     * Adds a Category
     *
     * @param \AmadeusAgentur\Indikationstabelle\Domain\Model\Category $indikationstabelle_filter
     * @return void
     */
    public function addCategory(\AmadeusAgentur\Indikationstabelle\Domain\Model\Category $indikationstabelle_filter)
    {

        $this->indikationstabelle_filter->attach($category);
    }

    /**
     * Removes a Category
     *
     * @param \AmadeusAgentur\Indikationstabelle\Domain\Model\Category $categoryToRemove The Category to be removed
     * @return void
     */
    public function removeCategory(\AmadeusAgentur\Indikationstabelle\Domain\Model\Category $categoryToRemove)
    {
        $this->indikationstabelle_filter->detach($categoryToRemove);
    }

    /**
     * Returns the categories
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\AmadeusAgentur\Indikationstabelle\Domain\Model\Category> $indikationstabelle_filter
     */
    public function getIndikationstabellefilter()
    {
        return $this->indikationstabelle_filter;
    }

    /**
     * Sets the categories
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\AmadeusAgentur\Indikationstabelle\Domain\Model\Category> $indikationstabelle_filter
     * @return void
     */
    public function setIndikationstabellefilter(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $indikationstabelle_filter)
    {
        $this->indikationstabelle_filter = $indikationstabelle_filter;
    }

    /**
     * @return mixed
     */
    public function getArtno()
    {
        return $this->artno;
    }

    /**
     * @param mixed $artno
     */
    public function setArtno($artno)
    {
        $this->artno = $artno;
    }

    /**
     * @return string
     */
    public function getArtdescr()
    {
        return $this->artdescr;
    }

    /**
     * @param string $artdescr
     */
    public function setArtdescr($artdescr)
    {
        $this->artdescr = $artdescr;
    }

    /**
     * @return mixed
     */
    public function getProductPageId()
    {
        return $this->product_page_id;
    }

    /**
     * @param mixed $product_page_id
     */
    public function setProductPageId($product_page_id)
    {
        $this->product_page_id = $product_page_id;
    }

}
