<?php

namespace AmadeusAgentur\Indikationstabelle\Controller;


/****************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2016 Jan-Frederic Schubert <jan-frederic.schubert@amadeus-agentur.com>, Amadeus Agentur
 *
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/
use AmadeusAgentur\Indikationstabelle\Domain\Model\Produkt;
use AmadeusAgentur\Indikationstabelle\Domain\Repository\ProduktRepository;
use TYPO3\CMS\Core\Category\Collection\CategoryCollection;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Object\ObjectManagerInterface;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;


/**
 * ProduktController
 *
 */
class ProduktController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{
    /**
     * @var array
     */
    private $jsonCategories = [];

    protected $objectManager;
    protected $productRepository;
    protected $pageRenderer;

    /**
     * @return void
     */
    public function injectObjectManagerInterface(ObjectManagerInterface $objectManager):void {
        $this->objectManager = $objectManager;
    }

    /**
     * @return void
     */
    public function injectProduktRepository(ProduktRepository $produktRepository):void {
        $this->productRepository = $produktRepository;
    }

    /**
     * @return void
     */
    public function listAction():void {

        #$this->productRepository = $this->objectManager->get('\AmadeusAgentur\Indikationstabelle\Domain\Repository\ProduktRepository');
        echo 'listView !';

        $this->view->assign('produkte', $this->productRepository->findAll());
    }

    /**
     *  index action
     */
    public function indexAction()
    {
        $this->pageRenderer = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance(\TYPO3\CMS\Core\Page\PageRenderer::class);
        $this->pageRenderer->addJsFooterLibrary('indikationstabelle_0', '//npmcdn.com/isotope-layout@3.0/dist/isotope.pkgd.min.js', 'text/javascript', false, false, '', true);
        #$GLOBALS['TSFE']->getPageRenderer()->addJsFooterLibrary('indikationstabelle_1', '/typo3conf/ext/indikationstabelle/Resources/Public/js/sw-product-lang-de.js', 'text/javascript', FALSE, FALSE, '', TRUE);
        #$GLOBALS['TSFE']->getPageRenderer()->addJsFooterLibrary('indikationstabelle_2', '/typo3conf/ext/indikationstabelle/Resources/Public/js/sw-product-data.js', 'text/javascript', FALSE, FALSE, '', TRUE);
        $this->pageRenderer->addJsFooterLibrary('indikationstabelle_3', '/typo3conf/ext/indikationstabelle/Resources/Public/js/sw-indikation-logic.js', 'text/javascript', false, false, '', true);

        $this->productRepository->setDefaultOrderings(["sorting" => QueryInterface::ORDER_ASCENDING]);
        $rawProdukt = $this->productRepository->findAll()->toArray();

        // Create query object
        $categoryRepository = $this->objectManager->get('TYPO3\CMS\Extbase\Domain\Repository\CategoryRepository');

        $categoryRepository->setDefaultOrderings(["sorting" => QueryInterface::ORDER_ASCENDING]);

        $categories = $categoryRepository->findAll()->toArray();

        $jsonCategories = [];
        $jsonProducts = [];


        foreach ($rawProdukt as $produkt) {

            $jsonProducts[$produkt->getUid()] = [
                'name'   => $produkt->getProName(),
                'artno'  => $produkt->getArtno(),
                'icon'   => $produkt->getIcon(),
                'filter' => [],
            ];
        }


        foreach ($categories as $category) {
            if ($category->getPid() != 295) {
                continue;
            }
            $jsonCategories = self::arrayMergeRecursiveDistinctOn('subfilter', $jsonCategories, $this->recursiveAddParent($category, []));

            $collection = CategoryCollection::load($category->getUid(), true, 'tx_indikationstabelle_domain_model_produkt', 'indikationstabelle_filter');

            foreach ($collection as $k => $v) {

                /* Todo: herausfinden, wieso jfs die abfrage nur für unsere IP gemacht hat */
//                if($_SERVER['REMOTE_ADDR'] == "87.138.162.211")
//                {
                        if($v['sys_language_uid'] != $GLOBALS['TSFE']->sys_language_uid) continue;
//                }

                $jsonProducts[$v['uid']]['name'] = $this->formatProductName($v['proname']);
                $jsonProducts[$v['uid']]['icon'] = $v['icon'];
                $jsonProducts[$v['uid']]['artno'] = $v['artno'];
                $jsonProducts[$v['uid']]['artdescr'] = $v['artdescr'];
                $jsonProducts[$v['uid']]['pageId'] = $v['product_page_id'];
                $jsonProducts[$v['uid']]['filter'][] = 'sw-filter-' . $category->getUid();
            }
        }

//        foreach ($jsonProducts as $k => $product) {
//
//            $domProducts .= '
//                    <div data-artno="' . $product['artno'] . '" data-pageid="'. $product['pageId'] .'" class="sw-product ' . implode(' ', $product['filter']) . '">
//                      <i class="sw-product-icon ' . $product['icon'] . '"></i>
//                       <div class="sw-product-name">' . $this->formatProductName($product['name']) . '</div>
//                       <div class="sw-product-description">' . $product['artdescr'] . '</div>
//
//                       </div>';
//        }


        //$domCategories = '<ul class="filter-grid">' . self::recursiveFilterCreator($jsonProducts, $jsonCategories['f34']['subfilter'], ['sw-filter'], 1) . '</ul>';

        //$this->view->assign('filter', $domCategories);
        $this->view->assign('products', $jsonProducts);
        $this->view->assign('filters', $jsonCategories['f34']['subfilter']);
        $this->view->assign('classes', 'sw-filter');
    }

    /**
     * @param $string
     * @return mixed
     */
    function formatProductName($string)
    {
        return preg_replace_callback('/SERA(.*?)®/', function ($matches) {
            return str_replace($matches[1], '<b>' . $matches[1] . '</b>', $matches[0]);
        }, $string);
    }

    /**
     * @param $filters
     * @param $classes
     * @param $depth
     * @return string
     */
    function recursiveFilterCreator($products, $filters, $classes, $depth):string {
        $r = '';

//        foreach ($filters as $k => $filter) {
//            $a = '';
//            if (count($filter['subfilter']) > 0) {
//                $a .= '<ul class="subfilter subfilter-' . $filter['_class'] . ' filter-level-' . $depth . '">
//                 ' . self::recursiveFilterCreator($products, $filter['subfilter'], array_merge($classes, [$filter['_class']]),
//                        $depth + 1) . '
//                </ul>';
//            } else {
//                $a .= '<div class="implants">';
//
//                foreach ($products as $k => $product) {
//
//                    if (in_array($filter['_class'], $product['filter'])) {
//                        $a .= '
//                        <div data-artno="' . $product['artno'] . '" data-pageid="' . $product['pageId'] . '" class="sw-product sw-filter ' . implode(' ', $product['filter']) . '">
//                            <div class="sw-product-inner" >
//                                <div class="sw-product-icon" data-amartn="' . $product['artno'] . '">
//                                    <div class="' . $product['icon'] . '"></div>
//                                </div>
//                                <h4 class="sw-product-name">' . $this->formatProductName($product['name']) . '<br /> <small class="sw-product-artno">'.str_replace(',',', ',$product['artno']).'</small>' .  ($product['artdescr'] ? '<br><small>' . $product['artdescr'] . '</small>' : '') . '</h4>
//
//                            </div>
//                        </div>';
//                    }
//                }
//                $filter['_class'] .= ' has-implants';
//                $a .= '</div>';
//
//            }
//
//
//            $subtitle = isset($filter['subtitle']) ? '<div class="filter-item--subtitle">' . $filter['subtitle'] . '</div>' : '';
//
//            $r .= '<li class="' . implode(' ', $classes) . ' ' . $filter['_class'] . '" data-filter="' . implode(' ',
//                    $classes) . ' ' . $filter['_class'] . '">
//                    <a class="filter-item--label">' . $filter['name'] . '</a>' . $subtitle;
//
//
//            $r .= $a . '</li>';
//        }

        return $r;
    }

    /**
     * @param $category
     * @param array $dataToAdd
     * @return array
     */
    function recursiveAddParent($category, array $dataToAdd):array {
        $array = [];
        $array['f' . $category->getUid()] = [
            'name'      => $category->getTitle(),
            'uid'       => $category->getUid(),
            '_class'    => 'sw-filter-' . $category->getUid(),
            'subfilter' => []
        ];
        if (!empty($dataToAdd)) {
            $array['f' . $category->getUid()]['subfilter'] = $dataToAdd;
        }
        if ($category->getDescription() != '') {
            $array['f' . $category->getUid()]['subtitle'] = $category->getDescription();
        }
        if ($category->getParent() != null) {
            $array = $this->recursiveAddParent($category->getParent(), $array);
        }

        return $array;
    }

    /**
     * @param $distinctKey
     * @param $array1
     * @param $array2
     * @return mixed
     */
    public static function arrayMergeRecursiveDistinctOn($distinctKey, &$array1, &$array2)
    {
        $merged = $array1;
        foreach ($array2 as $key => &$value) {
            if ($key == $distinctKey) {
                $merged[$key] = $merged[$key] + $array2[$key];
            }

            if (is_array($value) && isset($merged[$key]) && is_array($merged[$key])) {
                $merged[$key] = self::arrayMergeRecursiveDistinctOn($distinctKey, $merged[$key], $value);
            } else {
                $merged[$key] = $value;
            }
        }

        return $merged;
    }
}
