import Headroom from "headroom.js";

// select your header or whatever element you wish
const header = document.getElementById("page-header");

const options = {
    // vertical offset in px before element is first unpinned

    offset: {
        up: window.innerHeight * -2,
        down: window.innerHeight * 2
    },
    // scroll tolerance in px before state changes
    tolerance: {
        up: 0,
        down: 0
    },

    // css classes to apply
    classes: {
        // when element is initialised
        initial: "transition-transform duration-300 will-change-transform",
        // when scrolling up
        pinned: "translate-y-0",
        // when scrolling down
        unpinned: "-translate-y-full",
        // when above offset
        top: "is-top",
        // when below offset
        notTop: "not-top",
        // when at bottom of scroll area
        bottom: "is-bottom",
        // when not at bottom of scroll area
        notBottom: "not-bottom",
        // when frozen method has been called
        frozen: "is-frozen"

    },
}

const headroom = new Headroom(header, options);

headroom.init();
