import Alpine from '@alpinejs/csp'
//import collapse from '@alpinejs/collapse'

//Alpine.plugin(collapse)

window.Alpine = Alpine

Alpine.start()

Alpine.data('page', () => ({
    isMobile: (window.innerWidth < 1440),
    useHamburger: (window.innerWidth < 1648),

    checkSize() {
        this.isMobile = (window.innerWidth < 1440)
        this.useHamburger = (window.innerWidth < 1648)
    },

    isDesktop() {
        return !this.isMobile
    },

    useNavbar() {
        return !this.useHamburger
    }
}))

Alpine.data('hamburger', () => ({
    isOpen: false,

    get openCss() {
        return this.isOpen ? 'open' : 'closed';
    },

    toggleNav() {
        this.isOpen = ! this.isOpen
    }
}))

Alpine.data('layermenu', () => ({
    isOpen: false,

    get openCss() {
        return this.isOpen ? 'left-0' : 'left-full';
    },

    toggleLayer() {
        this.isOpen = ! this.isOpen
    }
}))

Alpine.data('accordion', () => ({
    isOpen: false,

    get headerCss() {
        return this.isOpen ? 'is-open' : 'text-primary';
    },

    get innerCss() {
        return this.isOpen ? 'max-h-screen' : 'max-h-0';
    },

    get outerCss() {
        return this.isOpen ? 'bg-gray1 border-gray1' : 'bg-transparent border-primary';
    },

    toggleAccordion() {
        this.isOpen = ! this.isOpen
    }
}))

