<?php
return [
    'ctrl' => [
        'label' => 'name',
        'title' => 'LLL:EXT:diepa_sitepackage/Resources/Private/Language/locallang_be.xlf:testimonial',
        'typeicon_classes' => [
            'default' => 'testimonial',
        ],
    ],
    'columns' => [
        'title' => [
            'exclude' => false,
            'label' => 'LLL:EXT:diepa_sitepackage/Resources/Private/Language/locallang_be.xlf:testimonial.title',
            'required' => true,
            'config' => [
                'type' => 'input',
                'eval' => 'trim',
                'max' => '200',
                'behaviour' => [
                    'allowLanguageSynchronization' => true,
                ],
            ]
        ],
        'bodytext' => [
            'exclude' => false,
            'label' => 'LLL:EXT:diepa_sitepackage/Resources/Private/Language/locallang_be.xlf:testimonial.bodytext',
            'config' => [
                'type' => 'text',
                'eval' => 'trim',
                'max' => '400',
                'behaviour' => [
                    'allowLanguageSynchronization' => true,
                ],
            ]
        ],
        'rating' => [
            'label' => 'LLL:EXT:diepa_sitepackage/Resources/Private/Language/locallang_be.xlf:testimonial.rating',
            'config' => [
                'type' => 'number',
                'format' => 'decimal',
                'range' => [
                    'lower' => 0,
                    'upper' => 5,
                ],
            ],
        ],
        'name' => [
            'exclude' => false,
            'label' => 'LLL:EXT:diepa_sitepackage/Resources/Private/Language/locallang_be.xlf:testimonial.name',
            'config' => [
                'type' => 'input',
                'eval' => 'trim',
                'max' => '128',
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ],
            ],
        ],
        'position' => [
            'label' => 'LLL:EXT:diepa_sitepackage/Resources/Private/Language/locallang_be.xlf:testimonial.position',
            'config' => [
                'type' => 'input',
                'eval' => 'trim',
                'max' => '128',
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ],
            ],
        ],
    ],
    'types' => [
        '0' => [
            'showitem' => 'title, bodytext, name, position, rating'
        ]
    ]
];
