<?php

use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;

if (!defined('TYPO3')) {
    die('Access denied.');
}


// Plugin & flexform registration
\TYPO3\CMS\Extbase\Utility\ExtensionUtility::registerPlugin(
    'diepa_sitepackage',
    'ContactRenderer',
    'Kontakt-Renderer',
    'EXT:diepa_sitepackage/Resources/Public/Icons/Extension.png'
);

\TYPO3\CMS\Extbase\Utility\ExtensionUtility::registerPlugin(
    'diepa_sitepackage',
    'TestimonialSlider',
    'Kundenstatement-Slider',
    'EXT:diepa_sitepackage/Resources/Public/Icons/Extension.png'
);

$GLOBALS['TCA']['tt_content']['types']['list']['subtypes_addlist']['diepasitepackage_contactrenderer'] = 'pi_flexform';
\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addPiFlexFormValue(
    'diepasitepackage_contactrenderer',
    // Flexform configuration schema file
    'FILE:EXT:diepa_sitepackage/Configuration/FlexForms/ContactRenderer.xml'
);

$GLOBALS['TCA']['tt_content']['types']['list']['subtypes_addlist']['diepasitepackage_testimonialslider'] = 'pi_flexform';
\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addPiFlexFormValue(
    'diepasitepackage_testimonialslider',
    // Flexform configuration schema file
    'FILE:EXT:diepa_sitepackage/Configuration/FlexForms/TestimonialSlider.xml'
);


// Additional TCA fields
$tempContentColumns = [
    'color_scheme' => [
        'exclude' => false,
        'label' => 'LLL:EXT:diepa_sitepackage/Resources/Private/Language/locallang_be.xlf:general.colorscheme.label',
        'description' => 'LLL:EXT:diepa_sitepackage/Resources/Private/Language/locallang_be.xlf:general.colorscheme.description',
        'config' => [
            'type' => 'select',
            'renderType' => 'selectSingle',
            'items' => [
                [
                    'label' => 'LLL:EXT:diepa_sitepackage/Resources/Private/Language/locallang_be.xlf:general.colorscheme.transparent',
                    'value' => 'transparent',
                ],
                [
                    'label' => 'LLL:EXT:diepa_sitepackage/Resources/Private/Language/locallang_be.xlf:general.colorscheme.light',
                    'value' => 'gray1',
                ],
                [
                    'label' => 'LLL:EXT:diepa_sitepackage/Resources/Private/Language/locallang_be.xlf:general.colorscheme.dark',
                    'value' => 'gray2',
                ],
            ],
            'default' => 'transparent',
        ],
        'l10n_mode' => 'exclude',
    ],
];

ExtensionManagementUtility::addTCAcolumns(
    'tt_content',
    $tempContentColumns
);

unset($tempContentColumns);

ExtensionManagementUtility::addFieldsToPalette(
    'tt_content',
    'frames',
    '--linebreak--,color_scheme',
    ''
);
