<?php
defined('TYPO3') or die('Access denied.');
call_user_func(function()
{
    /**
     * Temporary variables
     */
    $extensionKey = 'diepa_sitepackage';

    /**
     * Default PageTS for DiepaSitepackage
     */
    \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::registerPageTSConfigFile(
        $extensionKey,
        'Configuration/TsConfig/Page/All.tsconfig',
        'DIEPA Sitepackage'
    );

    $fields = array(
        /*'menutext1' => array(
            'label' => 'Menu Text (e.g. in Mainnavigation)',
            'exclude' => 1,
            'config' => array(
                'type' => 'text',
                'eval' => 'trim,nospace',
                'max' => 255
            ),
        ),*/
        'hero_video' => [
            'exclude' => false,
            'label' => 'LLL:EXT:diepa_sitepackage/Resources/Private/Language/locallang_be.xlf:page.hero',
            'config' => [
                'type' => 'file',
                'maxitems' => 1,
                'allowed' => ['jpg', 'webp', 'mp4', 'mov', 'webm'],
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],
        'teaser_image' => [
            'exclude' => true,
            'label' => 'LLL:EXT:diepa_sitepackage/Resources/Private/Language/locallang_be.xlf:page.teaser',
            'config' => \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::getFileFieldTCAConfig(
                'teaser_image',
                [
                    // Use the imageoverlayPalette instead of the basicoverlayPalette
                    'overrideChildTca' => [
                        'types' => [
                            '0' => [
                                'showitem' => '
                                    --palette--;;imageoverlayPalette,
                                    --palette--;;filePalette'
                            ],
                            \TYPO3\CMS\Core\Resource\File::FILETYPE_IMAGE => [
                                'showitem' => '
                                    --palette--;;imageoverlayPalette,
                                    --palette--;;filePalette'
                            ]
                        ]
                    ],
                    'behaviour' => [
                        'allowLanguageSynchronization' => true
                    ]
                ],
                'jpg,png,webp,avif'
            )
        ],
        'teaser_overlay' => [
            'exclude' => true,
            'label' => 'LLL:EXT:diepa_sitepackage/Resources/Private/Language/locallang_be.xlf:page.overlay',
            'config' => \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::getFileFieldTCAConfig(
                'teaser_overlay',
                [
                    // Use the imageoverlayPalette instead of the basicoverlayPalette
                    'overrideChildTca' => [
                        'types' => [
                            '0' => [
                                'showitem' => '
                                    --palette--;;imageoverlayPalette,
                                    --palette--;;filePalette'
                            ],
                            \TYPO3\CMS\Core\Resource\File::FILETYPE_IMAGE => [
                                'showitem' => '
                                    --palette--;;imageoverlayPalette,
                                    --palette--;;filePalette'
                            ]
                        ]
                    ],
                    'behaviour' => [
                        'allowLanguageSynchronization' => true
                    ]
                ],
                'png,webp,avif'
            )
        ],
        'teaser_video' => [
            'exclude' => false,
            'label' => 'LLL:EXT:diepa_sitepackage/Resources/Private/Language/locallang_be.xlf:page.video',
            'config' => [
                'type' => 'file',
                'maxitems' => 1,
                'allowed' => ['mp4', 'mov', 'webm'],
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],
    );

    // Add new fields to pages:
    \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addTCAcolumns('pages', $fields);

    // Make fields visible in the TCEforms:
    \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addToAllTCAtypes(
        'pages', // Table name
        '--palette--;Additional Infos;additional_infos', // Field list to add
        '', // List of specific types to add the field list to. (If empty, all type entries are affected)
        'after:title' // Insert fields before (default) or after one, or replace a field
    );

    // Add the new palette:
    $GLOBALS['TCA']['pages']['palettes']['additional_infos'] = array(
        'showitem' => 'teaser_image,--linebreak--,teaser_overlay,--linebreak--,hero_video,--linebreak--,teaser_video'
    );
});
