<?php

namespace AmadeusAgentur\DiepaSitepackage\Controller;

use AmadeusAgentur\DiepaSitepackage\Domain\Repository\ContactRepository;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use Psr\Http\Message\ResponseInterface;

class ContactController extends ActionController
{
    private $contactRepo;

    public function injectContactRepository(ContactRepository $conRepo): void {
        $this->contactRepo = $conRepo;
    }

    public function renderAction(): ResponseInterface {
        $contact_raw = $this->contactRepo->findByUid($this->settings['contact']);

        $contact['name'] = $contact_raw->getName();
        $contact['mail'] = $contact_raw->getMail();
        $contact['mailLink'] = 'mailto:' . str_replace(' ', '', $contact['mail']);
        $contact['position'] = $contact_raw->getPosition();
        $contact['telephone'] = $contact_raw->getTelephone();
        $contact['telephoneLink'] = preg_replace("/\([^)]+\)/","", str_replace(array(' ','-'), '', $contact['telephone']));

        if ($contact['telephoneLink'][0] == '0') {
            $contact['telephoneLink'] = substr($contact['telephoneLink'], 1);
        }

        if ($contact['telephoneLink'][0] != '+') {
            $contact['telephoneLink'] = '+49' . $contact['telephoneLink'];
        }

        $contact['telephoneLink'] = 'tel:' . $contact['telephoneLink'];

        $this->view->assign('contact', $contact);

        return $this->htmlResponse();
    }
}