/** @type {import('tailwindcss').Config} */

// Get settings from shopify themes editor
// const colors = require('tailwindcss/colors')

module.exports = {
    content: [
        // "../Resources/Private/**/*.{html,js}",
        "../Configuration/RTE/*.yaml",
    ],
    safelist: ['ck-content'],
    corePlugins: {
        preflight: false
    },
    theme: {
        extend: {
            fontFamily: {
                body: ['var(--font-body-family)'],
                heading: ['var(--font-heading-family)']
            },
            colors: {
                primary: 'oklch(var(--color-primary) / <alpha-value>)',
                primary_fallback: 'rgb(var(--color-primary-fallback) / <alpha-value>)',
                secondary: 'oklch(var(--color-secondary) / <alpha-value>)',
                secondary_fallback: 'rgb(var(--color-secondary-fallback) / <alpha-value>)'
            },
        },
    },
    plugins: [
        require('@tailwindcss/typography')({
            className: 'ck-content'
        }),
    ]
}

