/** @type {import('tailwindcss').Config} */

// Get settings from shopify themes editor
const colors = require('tailwindcss/colors')

module.exports = {
    content: [
        "../Resources/Private/**/*.{html,js}",
        "../Configuration/**/*.yaml",
        "node_modules/preline/dist/*.js"
    ],
    safelist: [
        'auto-rows-max',
        'bg-gradient-to-b', 'lg:bg-gradient-to-r', 'bg-transparent', 'bottom-16', 'button1', 'button2',
        'cec-below', 'ce-headline-center', 'ce-headline-right', 'lg:container',
        'from-35%', 'from-85%', 'lg:from-35%', 'from-white', 'lg:flex-row', 'lg:flex-nowrap',
        'gap-12', 'grid', 'grid-cols-1', 'lg:grid-cols-2',
        'lg:mb-8',
        'max-h-[892px]', 'max-w-[1280px]', '-mt-16', 'lg:mt-0',
        'overflow-x-hidden', 'overflow-y-hidden', '3xl:overflow-y-hidden',
        'pseudo-grid', 'prose', 'lg:pt-0', 'lg:pt-16', 'pt-12', 'pt-16', 'px-8', 'lg:px-12',
        'to-75%', 'lg:to-75%', 'to-transparent'
    ],

    theme: {
        container: {
            center: true,
            padding: {
                DEFAULT: '2rem',
                xl: '20px',
            }
        },
        fontFamily: {
            body: ['var(--font-body-family)'],
            heading: ['var(--font-heading-family)']
        },
        extend: {
            boxShadow: {
                'left': '-4px 4px 6px -1px rgb(0 0 0 / 0.1), -2px 2px 4px -2px rgb(0 0 0 / 0.1)'
            },
            colors: {
                primary: 'oklch(var(--color-primary) / <alpha-value>)',
                primary_fallback: 'rgb(var(--color-primary-fallback) / <alpha-value>)',
                secondary: 'oklch(var(--color-secondary) / <alpha-value>)',
                secondary_fallback: 'rgb(var(--color-secondary-fallback) / <alpha-value>)',
                gray1: 'oklch(var(--color-gray1) / <alpha-value>)',
                gray1_fallback: 'rgb(var(--color-gray1-fallback) / <alpha-value>)',
                gray2: 'oklch(var(--color-gray2) / <alpha-value>)',
                gray2_fallback: 'rgb(var(--color-gray2-fallback) / <alpha-value>)',
            },
            lineHeight: {
                '29': '7.25rem',
            },
            maxWidth: {
                '3/4': '75%',
                unset: 'unset'
            },
            maxHeight: {
                unset: 'unset'
            },
            animation: {
                // backdropPlörr: 'backdropPlörr 1000ms cubic-bezier(0.16, 1, 0.3, 1) forwards',
                // backdropFade: 'backdropFade 500ms cubic-bezier(0.16, 1, 0.3, 1) forwards',
            },
            keyframes: {
                // backdropPlörr: {
                //     'from': {
                //         transform: 'translate(-50%, -100%) scale(.001)',
                //         opacity: '0'
                //     },
                //
                //     'to': {
                //         transform: 'translate(-50%, -50%) scale(1)',
                //         opacity: '1'
                //     },
                //
                // },
                // backdropFade: {
                //     'from': {
                //         opacity: '0'
                //     },
                //
                //     'to': {
                //         opacity: '1'
                //     },
                //
                // }
            },
            screens: {
                'xl': '1440px',
                '2xl': '1648px',
                '3xl': '1920px',
            },
            transitionDuration: {
                '400': '400ms',
            },
            transitionProperty: {
                'spacing': 'margin, gap',
                'left': 'left,'
            },
            text: {
                '3xl': '2rem',
            },
            width: {
                '25': '6.25rem',
                '35': '8.75rem',
                '59': '238px',
            }
        },
    },
    plugins: [
        require('@tailwindcss/typography'),
        require('@tailwindcss/forms'),
        require('tailwindcss-animatecss'),
        require('preline/plugin'),
    ]
}

