{namespace name="netzperfekt/events"}
{if ! $netzpAppCancel}
    <script src="https://cdnjs.cloudflare.com/ajax/libs/vue/2.4.2/vue.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/vue-resource/1.3.4/vue-resource.min.js"></script>
    <script type="text/x-template" id="modal-template">
        <transition name="modal">
            <div class="modal-mask">
                <div class="modal-wrapper">
                    <div class="modal-container" v-on:keyup.esc="$emit('close')">
                        <div class="modal-category">
                            <slot name="category">
                            </slot>
                        </div>

                        <slot name="header">
                        </slot>

                        <div class="modal-meta">
                            <slot name="meta">
                            </slot>
                        </div>

                        <div class="modal-body">
                            <slot name="image">
                            </slot>

                            <slot name="body">
                            </slot>
                        </div>

                        <div class="modal-footer">
                            <div class="footer-left">
                                <slot name="footer-left">
                                </slot>
                            </div>
                            <div class="footer-middle">
                                <slot name="footer-middle">
                                </slot>
                            </div>
                            <div class="footer-right">
                                <slot name="footer-right">
                                    <a class="btn is--secondary" @click="$emit('close')"> OK </a>
                                </slot>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </transition>
    </script>
    <script type="text/x-template" id="map-template">
        <transition name="map">
            <div class="map-mask">
                <div class="map-wrapper">
                    <div class="map-container" v-on:keyup.esc="$emit('close')">

                        <slot name="header"></slot>

                        <div class="map-body">
                            <iframe v-bind:src=getMapEmbed(street) class="mapframe" frameborder="0"></iframe>
                        </div>

                        <div class="map-footer">
                            <div class="footer-left">
                                @( street ),@( zip ) @( city ),@( country )
                            </div>

                            <div class="footer-right">
                                <slot name="footer-right">
                                    <a class="btn is--secondary" @click="$emit('close')"> OK </a>
                                </slot>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </transition>
    </script>
    <div id="netzp-eventsapp">
        <div class="categories" v-if="categories.length > 1" v-cloak>
            <div class="title">
                <strong>{s name="categories"}Kategorien{/s}</strong> {s name="msg_clicktoselect"}(durch Klicken auswählbar){/s}
            </div>

            <div v-for="(value, key) in categories" class="category" @click="value.selected = !value.selected">
                <img v-if=value.icon v-bind:src=value.icon v-bind:class="{ 'dimmed': ! value.selected }">
                <div v-if=!value.icon class="nopicture">&nbsp;</div>

                <small v-bind:class="{ 'dimmed': ! value.selected }">@( value.name )</small>
            </div>
        </div>

        <div class="timeframe">
            <div class="range">
                {s name="range"}Zeitraum:{/s} @( rangeString )
            </div>

            <div class="range-buttons">
                <a @click="setRange(0)" class="btn is--small" v-bind:class="{ 'is--secondary': dateRange == 0 }">{s name="week"}Woche{/s}</a>
                <a @click="setRange(1)" class="btn is--small" v-bind:class="{ 'is--secondary': dateRange == 1 }">{s name="month"}Monat{/s}</a>
                <a @click="setRange(2)" class="btn is--small" v-bind:class="{ 'is--secondary': dateRange == 2 }">{s name="year"}Jahr{/s}</a>
            </div>

            <div class="buttons">
                <span v-show="isLoading" class="loading"><i class="icon--clock"></i></span>
                <a @click="fetchData(startTicks - endTicks+startTicks, startTicks-1)" class="btn"
                   v-bind:disabled="!isBackEnabled">{s name="back"}Zurück{/s}</a>
                <a @click="fetchData(endTicks + 1, endTicks + endTicks-startTicks)" class="btn">{s name="next"}Weiter{/s}</a>
            </div>
        </div>

        <template v-if="eventlist.length">
            <transition-group name="animatelist" tag="div" class="events-list" appear>
                <div v-for="(value, index) in eventlist" class="event-card"
                     v-bind:key="index"
                     v-bind:class="{ 'highlight': value.highlight == 1 }" v-cloak>
                    <div class="event-meta">
                        <div class="event-category">@( value.catname )</div>
                        <div class="event-daterange">@( value.dateRangeString )</div>
                        <div class="event-location" v-if=value.place>
                            {if $addonBookings && {config name=netzpEventsBookingMap} == 1}
                                <a v-if="value.street && value.city" @click="setMap(index, true)">@( value.place )</a>
                                <span v-else>@( value.place )</span>
                            {else}
                                @( value.place )
                            {/if}
                        </div>
                        <div v-if="value.image" class="event-image">
                            <img v-bind:src=value.image>
                        </div>
                    </div>

                    <h2 class="event-title">@( value.name )</h2>


                    <div v-if=hasShortDescription(value) v-html=value.shortdescription class="event-shortdescription"></div>


                    <div class="event-links">
                        <a v-if="value.url && !isBookable(value)" v-bind:href=value.url v-bind:target=getLinkTarget(value.url) rel="noopener" class="btn is--secondary" v-bind:title=value.urltext>
                            &nbsp;<i class="icon--link"></i>&nbsp;<template v-if="value.urltext">@(value.urltext)</template><template v-else>@(value.url)</template></a>

                        {if $addonBookings}
                            <span v-if="isBookable(value) && isFree(value) && configShowfree == 2"
                                  v-html="'<b>' + getFreePlaces(value) + '</b> {s name="places"}Plätze{/s}'"></span>
                            <a v-if="isBookable(value) && isFree(value)" v-bind:href=getBookingLink(value) class="btn is--secondary">{s name="goto_booking"}Zur Buchung{/s}</a>
                            <span v-if="isBookable(value) && !isFree(value)">{s name="msg_fullybooked"}- Leider ausgebucht-{/s}</span>
                        {/if}
                        <a v-if=value.description @click="setModal(index, true)" class="btn">{s name="infos"}Infos{/s}</a>

                    </div>

                    <showmap v-if="showMap[index]" @close="setMap(index, false)" v-cloak
                             v-bind:street=value.street
                             v-bind:zip=value.zip
                             v-bind:city=value.city
                             v-bind:country=value.country>

                        <div slot="header" class="map-header">
                            {s name="map"}Karte{/s} - @( value.name)
                        </div>

                    </showmap>

                    <modal v-if="showModal[index]" @close="setModal(index, false)" v-cloak>

                        <div slot="category">
                            <img v-if=value.caticon v-bind:src=value.caticon>
                            <div v-if=!value.caticon class="nopicture">&nbsp;</div>

                            <small>@( value.catname )</small>
                        </div>

                        <div slot="header" class="modal-header" v-bind:class="{ 'highlight': value.highlight == 1 }">
                            @( value.name )
                        </div>

                        <div slot="meta">
                            <div class="date"><i class="icon--calendar"></i> @( value.dateRangeString )</div>
                            <div class="time"><i class="icon--clock"></i> @( value.timeRangeString )</div>

                            <div class="place" v-if=value.place><i class="icon--location"></i>
                                {if $addonBookings && {config name=netzpEventsBookingMap} == 1}
                                    <a v-if="value.street && value.city" @click="setMap(index, true)">@( value.place
                                        )</a>
                                    <span v-else>@( value.place )</span>
                                {else}
                                    @( value.place )
                                {/if}
                            </div>

                            <div class="price" v-if=value.price><i class="icon--ticket"></i> @( value.price )</div>
                        </div>

                        <div slot="image" class="modal-image" v-if=value.image>
                            <img v-bind:src=value.image>
                        </div>

                        <div slot="body" v-html=value.description></div>

                        <a v-if="!isBookable(value) && value.url && value.urltext"
                           slot="footer-left" class="btn is--primary"
                           v-bind:href=value.url v-bind:target=getLinkTarget(value.url)>@( value.urltext )</a>
                        <a v-if="!isBookable(value) && value.url && !value.urltext"
                           slot="footer-left" class="btn is--primary"
                           v-bind:href=value.url v-bind:target=getLinkTarget(value.url)>{s name="infos_more"}Mehr Infos{/s}</a>

                        {if $addonBookings}
                            <a slot="footer-middle" v-if="isBookable(value) && isFree(value)" v-bind:href=getBookingLink(value) class="btn is--secondary">{s name="goto_booking"}Zur Buchung{/s}</a>
                            <span slot="footer-middle" v-if="isBookable(value) && !isFree(value)" class="btn">{s name="msg_fullybooked"}- Leider ausgebucht -{/s}</span>
                        {/if}
                        <span slot="footer-middle"
                              v-if="isBookable(value) && isFree(value) && configShowfree == 2"
                              v-html="'&nbsp;&nbsp;&nbsp;<b>' + getFreePlaces(value) + '</b> {s name="free_places"}freie Plätze{/s}'"></span>
                    </modal>

                </div>
            </transition-group>
        </template>

        <div v-else class="events-list">
            <div class="noevents" v-if=!isLoading v-cloak>
                <p>{s name="msg_noentries"}Im gewählten Zeitraum sind keine Einträge vorhanden.{/s}</p>
            </div>
        </div>

    </div>
    <script>
        var _basepath = '{$basepath}';
        var _categoryid = '{$categoryId}';
        var _configShowfree = '{config name="netzpEventsShowFree"}';
    </script>
    <script src="{link file='widgets/netzp_events/js/app.js'}?{1|rand:99999}"></script>
{/if}
