<?php

namespace Shopware\Themes\ClaTheme;

use Doctrine\Common\Collections\ArrayCollection;
use Shopware\Components\Theme\ConfigSet;
use Shopware\Components\Form\Container\TabContainer;
use Shopware\Components\Form as Form;

class Theme extends \Shopware\Components\Theme
{
    protected $extend = 'Responsive';
    protected $name = 'CLA v2017';
    protected $description = '';
    protected $author = 'amadeus agentur';
    protected $license = 'UNLICENSED';
    protected $inheritanceConfig = true;
    protected $injectBeforePlugins = false;
    /**
     * Javascript files which will be used in the theme.
     *
     * @var array
     */
    protected $javascript = [
        // Third party plugins / libraries
        'vendors/fonts/fontscom/mtiFontTrackingCode.js',
        'src/js/jquery.search.js'
    ];
    private $themeColorDefaults = [
        "desktopLogo" => "frontend/_public/src/img/logos/cla-logo-xl.svg",
        "tabletLandscapeLogo" => "frontend/_public/src/img/logos/cla-logo-xl.svg",
        "tabletLogo" => "frontend/_public/src/img/logos/cla-logo-xl.svg",
        "mobileLogo" => "frontend/_public/src/img/logos/cla-logo-xl.svg",
        "offcanvasCart" => true,
        "offcanvasOverlayPage" => true,
        "focusSearch" => true,
        "infiniteScrolling" => false,
        "infiniteThreshold" => 2,
        "displaySidebar" => true,
        "sidebarFilter" => true,
        "checkoutHeader" => false,
        "checkoutFooter" => false,
        'brand-primary' => '#a5a913',
        'brand-primary-light' => 'saturate(lighten(@brand-primary,5%), 5%)',
        'brand-secondary' => '#797a7b',
        'brand-secondary-dark' => 'darken(@brand-secondary, 15%)',
        'gray' => 'lighten(#797a7b,30%)',
        'gray-light' => 'lighten(@gray, 19%)',
        'gray-dark' => 'darken(@gray-light, 5%)',
        'border-color' => '@gray-dark',
        'highlight-success' => '#469408',
        'highlight-error' => '#D9230F',
        'highlight-notice' => '#ffc107',
        'highlight-info' => '#007bff',
        'body-bg' => '#fff',
        'overlay-bg' => '#000000',
        'overlay-dark-bg' => '@overlay-bg',
        'overlay-light-bg' => '#FFFFFF',
        'overlay-opacity' => '0.7',
        'text-color' => '#414447',
        'text-color-dark' => '@brand-secondary-dark',
        'link-color' => '@brand-primary',
        'link-hover-color' => 'darken(@link-color, 10%)',
        'rating-star-color' => '@highlight-notice',
        'btn-default-top-bg' => '#FFFFFF',
        'btn-default-bottom-bg' => '@gray-light',
        'btn-default-hover-bg' => '#FFFFFF',
        'btn-default-text-color' => '@text-color',
        'btn-default-hover-text-color' => '@brand-primary',
        'btn-default-border-color' => '@border-color',
        'btn-default-hover-border-color' => '@brand-primary',
        'btn-primary-top-bg' => '@brand-primary',
        'btn-primary-bottom-bg' => 'btn-primary-bottom-bg',
        'btn-primary-hover-bg' => '@brand-primary-light',
        'btn-primary-text-color' => '#FFFFFF',
        'btn-primary-hover-text-color' => '@btn-primary-text-color',
        'btn-secondary-top-bg' => '@brand-secondary',
        'btn-secondary-bottom-bg' => '@brand-secondary-dark',
        'btn-secondary-hover-bg' => '@brand-secondary-dark',
        'btn-secondary-text-color' => '#FFFFFF',
        'btn-secondary-hover-text-color' => '@btn-secondary-text-color',
        'panel-header-bg' => '@gray-light',
        'panel-header-color' => '@text-color',
        'panel-border' => '@border-color',
        'panel-bg' => '#FFFFFF',
        'label-color' => '@text-color',
        'input-bg' => '@gray-light',
        'input-color' => '@brand-secondary',
        'input-placeholder-color' => 'lighten(@text-color, 15%)',
        'input-border' => '@border-color',
        'input-focus-bg' => '#FFFFFF',
        'input-focus-border' => '@brand-primary',
        'input-focus-color' => '@brand-secondary',
        'input-error-bg' => 'desaturate(lighten(@highlight-error, 38%), 20%)',
        'input-error-border' => '@highlight-error',
        'input-error-color' => '@highlight-error',
        'input-success-bg' => '#FFFFFF',
        'input-success-border' => '@highlight-success',
        'input-success-color' => '@brand-secondary-dark',
        'panel-table-header-bg' => '@panel-bg',
        'panel-table-header-color' => '@text-color-dark',
        'table-row-bg' => '#FFFFFF',
        'table-row-color' => '@brand-secondary',
        'table-row-highlight-bg' => 'darken(@table-row-bg, 4%)',
        'table-header-bg' => '@brand-secondary',
        'table-header-color' => '#FFFFFF',
        'badge-discount-bg' => '@highlight-error',
        'badge-discount-color' => '#FFFFFF',
        'badge-newcomer-bg' => '@highlight-notice',
        'badge-newcomer-color' => '#FFFFFF',
        'badge-recommendation-bg' => '@highlight-success',
        'badge-recommendation-color' => '#FFFFFF',
        'badge-download-bg' => '@highlight-info',
        'badge-download-color' => '#FFFFFF',
    ];
    /**
     * Holds default font configuration.
     *
     * @var array
     */
    private $themeFontDefaults = [
        'font-base-stack' => '"Avenir Next W01", sans-serif;',
        'font-headline-stack' => '"Rockwell W01", serif;',
        'font-size-base' => 15,
        'font-base-weight' => 400,
        'font-light-weight' => 300,
        'font-bold-weight' => 700,
        'font-size-h1' => 42,
        'font-size-h2' => 21,
        'font-size-h3' => 18,
        'font-size-h4' => 16,
        'font-size-h5' => '@font-size-base',
        'font-size-h6' => 12,
        'panel-header-font-size' => '@font-size-base',
        'label-font-size' => '@font-size-base',
        'input-font-size' => '@font-size-base',
        'btn-font-size' => '@font-size-base',
        'btn-icon-size' => '@font-size-base',
    ];

    /**
     * Holds default icon configuration.
     *
     * @var array
     */
    private $themeIconDefaults = [
        'appleTouchIcon' => 'frontend/_public/src/img/favicons/apple-touch-icon.png',
        'win8TileImage' => 'frontend/_public/src/img/favicons/mstile-310x310.png',
        'favicon' => 'frontend/_public/src/img/favicons/favicon-32x32.png'
    ];

    /**
     * Helper function to merge default theme colors with color schemes
     *
     * @param ArrayCollection $collection
     */
    public function createConfigSets(ArrayCollection $collection)
    {
        $set = new ConfigSet();
        $set->setName('CLA Default')
            ->setDescription('CLA Standard Einstellung')
            ->setValues(array_merge(
                $this->themeColorDefaults,
                $this->themeFontDefaults,
                $this->themeIconDefaults
                )
            );
        $collection->add($set);
    }
}
