// console.log('Amadeus Partsfinder');

var partsFinder;
var apContainer;
var currentModel;
var imgPath = '/themes/Frontend/ClaTheme/frontend/_public/src/img/disassembled/'

var aplang = {
    en: {
        zoom: 'Zoom in',
        showReplacementsOf: 'Show Components of:'
    },
    de: {
        zoom: 'Vergrößern',
        showReplacementsOf: 'Ersatzteile anzeigen für:'
    }
};


curLang = document.documentElement.lang.replace('-GB', '');
$(function () {
    partsFinder = $('#amadeus_partsfinder');
    setTimeout(ap_construct, 1);
});


function ap_construct() {

    apContainer = $('<div>').addClass('ap-container').appendTo(partsFinder);

    apSVGContainer = $('<div>').addClass('ap-svg-container').appendTo(partsFinder);

    btnGroup = $('<div>').addClass('btn-group').html('<span class="btn-group-label">' + aplang[curLang].showReplacementsOf + '</span>').appendTo(apContainer);
    //"CLA 6/4","CLA 6/6","CLA 6/7","CLA 6/7"

    parts.forEach(function (v, k) {
        $('<div>').addClass('btn btn--product').attr('data-id', v).text(v).appendTo(btnGroup);
    })

    $('<div>').addClass('btn btn--zoom').html('<i class="icon--plus3"></i>' + aplang[curLang].zoom).appendTo(apSVGContainer).on('click', ap_openZoom);

    $('.btn--product').on('click', ap_selectProduct)

}

function ap_openZoom() {
    $.modal.open(svgArea.clone(), {
        width: '100%',
        height: '100%',
        animationSpeed: 350,
        additionalClass: 'image-gallery--modal no--border-radius'
    });

    ap_svgLoaded();

}


function ap_selectProduct($evt) {
    $evt.preventDefault();

    $('#svgArea').remove();
    $('.is--active').removeClass('is--active');
    $($evt.currentTarget).addClass('is--active');

    id = $($evt.currentTarget).data('id');

    svgArea = $('<div>').attr("id", 'svgArea').appendTo(apSVGContainer);


    ap_svgLoaded();

    var imgName = id.replace(' ', '').replace("/", "_");
    currentModel = imgName;


    $obj = $('<object>')
        .attr('data', imgPath + imgName + '/' + imgName + '.svg')
        .attr('id', "svgObj")
        .attr('type', "image/svg+xml")
        .attr('height', 100)
        .attr('width', 100)
        .appendTo(svgArea);

    $obj.on('load', function (e) {
        var svgObj = e.currentTarget;
        var svgDoc = svgObj.contentDocument;
        var svg = svgDoc.firstChild;

        svgObj.parentNode.replaceChild(svg, svgObj);

        var img = document.getElementsByTagName('image');


        for (var i = 0; i < img.length; i++) {
            var imgName = img[i].getAttribute('xlink:href');
            img[i].setAttribute('xlink:href', imgPath + currentModel + '/' + imgName)
        }

        ap_svgLoaded(e);

    })


}

function ap_svgLoaded($evt) {

    $('#svgArea svg rect').bind('click', function (evt) {
        location.href = '/?ap_action=getPart&partnumber=' + evt.currentTarget.id;
    });

    $('#svgArea svg text').bind('click', function (evt) {
        location.href = '/?ap_action=getPart&partnumber=' + evt.currentTarget.innerHTML.replace(' ', '_').replace('/', '_x2F_');
    });

    $('#svgArea').addClass('is--loaded');

}


function ap_getPart(elem) {
    console.log(elem);
}


if (!Array.prototype.forEach) {

    Array.prototype.forEach = function (callback, thisArg) {

        var T, k;
        if (this == null) {
            throw new TypeError(' this is null or not defined');
        }
        // 1. Let O be the result of calling ToObject passing the |this| value as the argument.
        var O = Object(this);
        // 2. Let lenValue be the result of calling the Get internal method of O with the argument "length".
        // 3. Let len be ToUint32(lenValue).
        var len = O.length >>> 0;
        // 4. If IsCallable(callback) is false, throw a TypeError exception.
        // See: http://es5.github.com/#x9.11
        if (typeof callback !== "function") {
            throw new TypeError(callback + ' is not a function');
        }
        // 5. If thisArg was supplied, let T be thisArg; else let T be undefined.
        if (arguments.length > 1) {
            T = thisArg;
        }
        // 6. Let k be 0
        k = 0;
        // 7. Repeat, while k < len
        while (k < len) {
            var kValue;
            // a. Let Pk be ToString(k).
            //   This is implicit for LHS operands of the in operator
            // b. Let kPresent be the result of calling the HasProperty internal method of O with argument Pk.
            //   This step can be combined with c
            // c. If kPresent is true, then
            if (k in O) {
                // i. Let kValue be the result of calling the Get internal method of O with argument Pk.
                kValue = O[k];
                // ii. Call the Call internal method of callback with T as the this value and
                // argument list containing kValue, k, and O.
                callback.call(T, kValue, k, O);
            }
            // d. Increase k by 1.
            k++;
        }
        // 8. return undefined
    };
}
