<?php

namespace ClaPartfinder;

use Shopware\Components\Plugin;

class ClaPartfinder extends Plugin
{
    
    public static function getSubscribedEvents()
    {
        return [
            'Enlight_Controller_Action_PreDispatch_Frontend' => 'onPreDispatchFrontend',
        ];
    }
    
    public function onPreDispatchFrontend(\Enlight_Controller_ActionEventArgs $args)
    {
        $db = Shopware()->Db();
        switch ($args->getRequest()->get('ap_action')) {
            case "getPart":
                $id = $args->getRequest()->get('partnumber') ?? null;
                
                if($id === null) return;
                
                $SQL = 'Select id,ordernumber from s_articles_details where suppliernumber = ?';
                $stmt = $db->query($SQL,[str_replace(['_x2F_','_'],['/',' '],$id)]);
                $items = $stmt->fetchAll(\PDO::FETCH_ASSOC);
                
                $url = Shopware()->Front()->Router()->assemble(array('module' => 'frontend', 'sViewport' => 'detail', 'sArticle' => $items[0]['id']));
                
                header('LOCATION:'.$url); die();
        }
        
    }
}
