@servers(['production' => 'ssh-129219-autohausvetter@autohaus-vetter.com','stageing' => 'ssh-w0174f51@w0174f51.kasserver.com'])

@setup
$repository = "ssh://git@gitlab.amadeus-agentur.com:93/auto-vetter/website-project.git";

$path_production = "w014649f";
$path_stageing = "w0174f51";

$PHPCMD = "php72";


if($on == "production")
{

$releases_dir = "~/website.by.amadeus-agentur.com/releases";
$app_dir = "~/website.by.amadeus-agentur.com/";
$PHPCMD = "/usr/local/bin/php7-72LATEST-CLI";

}
elseif($on == "stageing")
{
$releases_dir = "/www/htdocs/w0174f51/av.dev.amadeus-agentur.com/releases";
$app_dir = "/www/htdocs/w0174f51/av.dev.amadeus-agentur.com";
}

if($release != null && $release != '' )
{
$app_release = $release;
}
else $app_release = date('YmdHis');


$new_release_dir = $releases_dir .'/'. $app_release;
@endsetup


@story('deploy',["on" => $on])
clone_repository
run_composer
update_symlinks
@endstory


@task('clone_repository')
echo 'Cloning repository'
echo 'Version: {{$app_release}}';
[ -d {{ $new_release_dir }} ] || mkdir -p {{ $new_release_dir }}
git clone --depth 1 {{ $repository }} {{ $new_release_dir }}

@endtask

@task('run_composer')
echo "Starting deployment ({{ $app_release }})"
cd {{ $new_release_dir }}
{{ $PHPCMD }} {{$app_dir}}/../bin/composer.phar install --no-dev --prefer-dist --no-scripts -q -o
@endtask

@task('update_symlinks')

echo "Linking uploads directory"
rm -rf {{ $new_release_dir }}/web/app/uploads
[ -d {{ $app_dir }}/uploads ] || mkdir -p {{ $app_dir }}/uploads
ln -nfs {{ $app_dir }}/uploads {{ $new_release_dir }}/web/app/uploads

echo 'Linking .env file'
[ -f {{ $app_dir }}/.env ] || cp {{ $new_release_dir }}/.env.example {{ $app_dir }}/.env
ln -nfs {{ $app_dir }}/.env {{ $new_release_dir }}/.env

echo 'Linking current release'
ln -nfs {{ $new_release_dir }} {{ $app_dir }}/current
@endtask
