let
    markerClusterer = [],

    countryInput = document.getElementById("tx_myttaddressmap_country"),
    addressInput = document.getElementById("tx_myttaddressmap_city"),
    latInput = document.getElementById("tx_myttaddressmap_lat"),
    lonInput = document.getElementById("tx_myttaddressmap_lon"),
    radiusInput = document.getElementById("tx_myttaddressmap_radius"),
    pageInput = document.getElementById("tx_myttaddressmap_page"),
    languageInput = document.getElementById("tx_myttaddressmap_language"),
    categoriesArray = Array.from(document.querySelectorAll("input[type=checkbox][name=tx_myttaddressmap_categories]:checked"), e => e.value),
    ajaxSearchButton = document.getElementById("ajaxSearchButton"),
    moreButton = document.getElementById("tx_myttaddressmap_more"),
    distance = []


// Googles autocomplete

let autocomplete = new google.maps.places.Autocomplete(addressInput, {
    types: ['(cities)'],
    componentRestrictions: {country: 'de'}
});

autocomplete.setFields(["place_id", "geometry", "name"]);

autocomplete.addListener("place_changed", function (e) {
    const place = autocomplete.getPlace();
    console.log(this);

    if (!place.geometry || !place.geometry.location) {
        // User entered the name of a place, pressed the enter key and no suggestions are available,
        // then clear input field and reset search to default

        window.alert("Ungültige Eingabe für: '" + place.name + "'");
        addressInput.value = ''
        geocodeByClient()
        return;
    }

    if (place.geometry.viewport) {
        geocodeByClient({
            lat: place.geometry.location.lat(),
            lon: place.geometry.location.lng(),
            radius: '50',
        })
        // map.fitBounds(place.geometry.viewport);
        //
        // console.log('y')

    } else {
        console.log('x')
        map.setCenter(place.geometry.location);
        map.setZoom(17);
    }
});

/* Simulate arrow down when hitting enter avoids autocomplete to fail */
enableEnterKey(addressInput)

function enableEnterKey(input) {

    /* Store original event listener */
    const _addEventListener = input.addEventListener

    const addEventListenerWrapper = (type, listener) => {
        if (type === 'keydown') {
            /* Store existing listener function */
            const _listener = listener
            listener = (event) => {
                /* Simulate a 'down arrow' keypress if no address has been selected */
                const suggestionSelected = document.getElementsByClassName('pac-item-selected').length
                if (event.key === 'Enter' && !suggestionSelected) {
                    const e = new KeyboardEvent('keydown', {
                        key: 'ArrowDown',
                        code: 'ArrowDown',
                        keyCode: 40,
                    })
                    _listener.apply(input, [e])
                }
                _listener.apply(input, [event])
            }
        }
        _addEventListener.apply(input, [type, listener])
    }

    input.addEventListener = addEventListenerWrapper
}

/* Setup event listners for input fields */
document.addEventListener('change', function (e) {
    if (e.target.name == "tx_myttaddressmap_categories") {
        categoriesArray = Array.from(document.querySelectorAll("input[type=checkbox][name=tx_myttaddressmap_categories]:checked"), e => e.value)
        geocodeByClient({categories: categoriesArray})
    }
})

document.addEventListener('click', function (e) {
    if (e.target == ajaxSearchButton) {
        geocodeByClient({page: '0'});
        e.preventDefault();
    }

    if (e.target == moreButton) {
        geocodeByClient();
        e.preventDefault();
    }
})


window.addEventListener("resize", resizeMap);

myoptions = {
    country: 'DE',
    address: 'Untersiemau',
    lat: '50.19513815231214',
    lon: '10.967001888217688',
    radius: '2000',
    page: '0'

}

document.addEventListener("DOMContentLoaded", geocodeByClient);

function geocodeByClient(options = {}) {

    defaults = {
        id: id,
        country: countryInput.value || myoptions.country,
        address: addressInput.value || myoptions.address,
        lat: latInput.value || myoptions.lat,
        lon: lonInput.value || myoptions.lon,
        radius: radiusInput.value || myoptions.radius,
        page: pageInput.value || 0,
        language: languageInput.value,
        categories: categoriesArray || [],
        enableMarkerClusterer: enableMarkerClusterer
    };

    let opts = Object.assign({}, defaults, options);

    console.log(opts);

    let ajaxRequestUrl = "index.php?eIDx=myttaddressmap&id=" + opts.id,
        requestParameter = {
            tx_myttaddressmap_ajax: {
                controller: 'Ajax',
                action: 'ajaxPsr',
                address: opts.address,
                country: opts.country,
                lat: opts.lat,
                lon: opts.lon,
                radius: opts.radius,
                page: opts.page,
                language: opts.language,
                categories: opts.categories,

                b: location.href
            }
        };

    mapBounds = new google.maps.LatLngBounds();

    if (typeof(activeLocation) == 'object') {
        activeLocation.setMap(null);
    }

    activeLocation = new google.maps.Marker({
        position: { lat: opts.lat, lng: opts.lon },
        map,
        animation: google.maps.Animation.DROP,
        icon: {
            url: 'https://www.amo-debus.de/media/DATA/Icons/construction-site.png',
            size: new google.maps.Size(60, 50),
            scaledSize: new google.maps.Size(36, 30),
        },
        title: opts.address,
        zIndex: 7500,
    });

    if (opts.enableMarkerClusterer) {
        if (marker.length > 0) markerClusterer.clearMarkers();
    }


    /* Todo: remove jQuery */
    $.post(ajaxRequestUrl, requestParameter, function (data) {
        $('#ajaxResult').html(data);

        if (opts.enableMarkerClusterer) {
            markerClusterer = new MarkerClusterer(map, marker, {imagePath: '/typo3conf/ext/myttaddressmap/Resources/Public/Icons/Clusterer/m'});
        }

        initMarkerEvents();
        hideMoreButton(moreButton);

        if (addressInput.value != '') {
            Array.prototype.forEach.call(document.getElementsByClassName('address-distance'), function (element) {
                element.style.display = 'inline';
            });
        }


        if (marker.length <= 1)
            map.setZoom(15);

    });

    return false;
}

function hideMoreButton(elem) {
    var page = parseInt(pageInput.value);
    if (page != -1) {
        if (page + 1 < maxPage) {
            var n = page + 1;
            pageInput.value = n
            elem.style.display = 'block'
        } else {
            elem.style.display = 'none'
        }
    }
}


function toggleInfoWindows(elem) {
    for (var x in infoWindow) {
        if (x != elem) {
            infoWindow[x].close()

        } else {
            infoWindow[x].open(map, marker[x]);
            map.setZoom(11);
            map.setCenter(marker[x].getPosition());

            google.maps.event.addListener(infoWindow[x], 'closeclick', function () {
                map.fitBounds(mapBounds);
            });


        }
    }
}


function initMarkerEvents() {
    for (var x in marker) {
        addMarkerEvents(x);
    }
}

function addMarkerEvents(elem) {
    google.maps.event.addListener(marker[elem], 'click', function () {
        toggleInfoWindows(elem)
    })


}

function resizeMap() {
    if (marker.length > 0) map.fitBounds(mapBounds);
}

function toggleDisplay(elem) {
    if (elem.style.display === "none") {
        elem.style.display = "block";
    } else {
        elem.style.display = "none";
    }
}
