var noticeAsModal = (typeof noticeAsModalOverwrite !== 'undefined') ? noticeAsModalOverwrite : true;


var klaroConfig = {
    disablePoweredBy: true,
    acceptAll: true,
    mustConsent: false,
    hideDeclineAll: false,
    noticeAsModal: noticeAsModal,
    htmlTexts: true,
    testing: false,
    services: [
        {
            name: 'googleTagManager',
            required: false,
            default: true,
            purposes: ['functional'],
            onAccept: `
                // we notify the tag manager about all services that were accepted. You can define
                // a custom event in GTM to load the service if consent was given.
                for(let k of Object.keys(opts.consents)){
                    if (opts.consents[k]){
                        let eventName = 'klaro-'+k+'-accepted'
                        dataLayer.push({'event': eventName})
                    }
                }
                // if consent for Google Analytics was granted we enable analytics storage
                if (opts.consents[opts.vars.googleAnalyticsName || 'googleAnalytics']){
                    console.log("Google analytics usage was granted")
                    gtag('consent', 'update', {'analytics_storage': 'granted'})
                }
                // if consent for Google Ads was granted we enable ad storage
                if (opts.consents[opts.vars.adStorageName || 'google-ads']){
                    console.log("Google ads usage was granted")
                    gtag('consent', 'update', {'ad_storage': 'granted'})
                }
            `,
            onInit: `
                // initialization code here (will be executed only once per page-load)
                window.dataLayer = window.dataLayer || [];
                window.gtag = function(){dataLayer.push(arguments)}
                gtag('consent', 'default', {'ad_storage': 'denied', 'analytics_storage': 'denied'})
                gtag('set', 'ads_data_redaction', true)
            `,
            onDecline: `
                // initialization code here (will be executed only once per page-load)
                window.dataLayer = window.dataLayer || [];
                window.gtag = function(){dataLayer.push(arguments)}
                gtag('consent', 'default', {'ad_storage': 'denied', 'analytics_storage': 'denied'})
                gtag('set', 'ads_data_redaction', true)
            `,
            vars: {
                googleAnalyticsName: 'googleAnalytics',
                googleMapsName: 'googleMaps',
                mtiFontTrackingCodeName: 'mtiFontTrackingCode'
            }
        },
        {
            name: 'googleAnalytics',
            title: 'Google Analytics',
            purposes: ['analytics'],
            cookies: [/^ga/i],
            required: false,
            default: false,
        },
        {
            name: 'mtiFontTrackingCode',
            title: 'Fonts.com',
            purposes: ['functional'],
            cookies: [/^__cf_bm/i],
            required: false,
            default: true,
        },
        {
            name: 'googleMaps',
            title: 'Google Maps',
            purposes: ['functional'],
            default: true,
        },
    ],
};

if (typeof klaroConfigTranslations !== 'undefined') {
    for (var attr in klaroConfigTranslations) {
        klaroConfig[attr] = klaroConfigTranslations[attr];
    }
}
