<?php
defined( 'TYPO3_MODE' ) || die();


/***************
 * Add Content Element
 */
if ( ! is_array( $GLOBALS['TCA']['tt_content']['types']['amdsbear_hero'] ) ) {
	$GLOBALS['TCA']['tt_content']['types']['amdsbear_hero'] = [];
}

/***************
 * Add content element to selector list
 */
\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addTcaSelectItem(
	'tt_content',
	'CType',
	[
		'LLL:EXT:amds_bear/Resources/Private/Language/locallang_db.xlf:amdsbear_hero.wizard.title',
		'amdsbear_hero',
		'amdsbear_hero'
	],
	'listgroup',
	'after'
);

/***************
 * Assign Icon
 */
$GLOBALS['TCA']['tt_content']['ctrl']['typeicon_classes']['amdsbear_hero'] = 'amdsbear_hero';


/***************
 * Register fields
 */
$GLOBALS['TCA']['tt_content']['columns'] = array_replace_recursive(
	$GLOBALS['TCA']['tt_content']['columns'],
	[
		'tx_amdsbear_herosize' => [
			'label' => 'LLL:EXT:amds_bear/Resources/Private/Language/locallang_db.xlf:amdsbear_hero.tt_content.herosize',
			'config' => [
				'type' => 'select',
				'renderType' => 'selectSingle',
				'items' => [
					['LLL:EXT:amds_bear/Resources/Private/Language/locallang_db.xlf:amdsbear_hero.tt_content.herosize.normal', 'normal'],
					['LLL:EXT:amds_bear/Resources/Private/Language/locallang_db.xlf:amdsbear_hero.tt_content.herosize.condensed', 'condensed'],
					['LLL:EXT:amds_bear/Resources/Private/Language/locallang_db.xlf:amdsbear_hero.tt_content.herosize.expanded', 'expanded'],
					['LLL:EXT:amds_bear/Resources/Private/Language/locallang_db.xlf:amdsbear_hero.tt_content.herosize.fullsize', 'fullsize'],
				],
			],
		],
	]
);


/***************
 * Configure element type
 */

$GLOBALS['TCA']['tt_content']['types']['amdsbear_hero'] = array_replace_recursive(

	$GLOBALS['TCA']['tt_content']['types']['amdsbear_hero'],
	[

		'showitem'         => '
			--div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:general,
			--palette--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:palette.general;general,header,subheader,tx_amdsbear_herosize,bodytext,image,
			--div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.appearance,
			--palette--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:palette.frames;frames,
			--palette--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:palette.appearanceLinks;appearanceLinks,
			--div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:language,
			--palette--;;language,
			--div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:access,
			--palette--;;hidden,
			--palette--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:palette.access;access,
			--div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:categories,
			--div--;LLL:EXT:lang/Resources/Private/Language/locallang_tca.xlf:sys_category.tabs.category,categories,
			--div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:notes,rowDescription,
			--div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:extended',
		'columnsOverrides' =>
			[
				'bodytext' =>
					[
						'config' =>
							[
								'richtextConfiguration' => 'default',
								'enableRichtext'        => 1,
							],
					],
			],
	]

);
