<?php

namespace AmadeusAgentur\Bear\DataProcessing;

/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */

use TYPO3\CMS\Core\Page\PageRenderer;
use TYPO3\CMS\Core\Resource\FileRepository;
use TYPO3\CMS\Core\Service\FlexFormService;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer;
use TYPO3\CMS\Frontend\ContentObject\DataProcessorInterface;
use TYPO3\CMS\Frontend\Page\PageRepository;
use TYPO3\CMS\Frontend\Resource\FilePathSanitizer;


class BootstrapProcessor implements DataProcessorInterface
{
    
    /**
     * The content object renderer
     *
     * @var \TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer
     */
    protected $contentObjectRenderer;
    
    /**
     * The contentObject Configuration
     *
     * @var array
     */
    protected $contentObjectConfiguration;
    
    /**
     * The processor configuration
     *
     * @var array
     */
    protected $processorConfiguration;
    
    /**
     * The processedData
     *
     * @var array
     */
    protected $processedData;
    
    /**
     * The flexconf
     *
     * @var array
     */
    protected $flexconf;
    
    
    /**
     * Process data
     *
     * @param ContentObjectRenderer $cObj The data of the content element or page
     * @param array $contentObjectConfiguration The configuration of Content Object
     * @param array $processorConfiguration The configuration of this processor
     * @param array $processedData Key/value store of processed data (e.g. to be passed to a Fluid View)
     * @return array the processed data as key/value store
     */
    public function process(ContentObjectRenderer $cObj, array $contentObjectConfiguration, array $processorConfiguration, array $processedData)
    {
        
        $flexFormService = GeneralUtility::makeInstance(FlexFormService::class);
        $this->flexconf = $flexFormService->convertFlexFormContentToArray($processedData['data']['pi_flexform']);
        $this->parentflexconf = $flexFormService->convertFlexFormContentToArray($processedData['data']['parentgrid_tx_t3sbootstrap_flexform']);
        $this->contentObjectRenderer = $cObj;
        $this->contentObjectConfiguration = $contentObjectConfiguration;
        $this->processorConfiguration = $processorConfiguration;
        $this->processedData = $processedData;
        
        
        ##############################################################################################################################################
        /**
         * CType: Gridelements
         */
        ##############################################################################################################################################
        if ($this->processedData['data']['CType'] == 'gridelements_pi1') {
            
            if (is_array($this->processedData['data']['tx_gridelements_view_children'])) {
                $this->processedData['divWrap'] = FALSE;
            } else {
                $this->processedData['divWrap'] = TRUE;
            }
            
            
            /**
             * Grid
             */
            if (in_array($this->processedData['data']['tx_gridelements_backend_layout'], ["1-cols", "2-cols", "3-cols", "4-cols"])) {
                
                foreach ($this->flexconf as $key => $value) {
                    
                    if ($key == 'extraClass_one' || $key == 'extraClass_two' || $key == 'extraClass_three'
                        || $key == 'extraClass_four' || $key == 'extraClass_five' || $key == 'extraClass_six') {
                        
                        switch ($key) {
                            case 'extraClass_one':
                                $columnOneExtraClass = ' ' . $value;
                                break;
                            case 'extraClass_two':
                                $columnTwoExtraClass = ' ' . $value;
                                break;
                            case 'extraClass_three':
                                $columnThreeExtraClass = ' ' . $value;
                                break;
                            case 'extraClass_four':
                                $columnFourExtraClass = ' ' . $value;
                                break;
                            case 'extraClass_five':
                                $columnFiveExtraClass = ' ' . $value;
                                break;
                            case 'extraClass_six':
                                $columnSixExtraClass = ' ' . $value;
                                break;
                        }
                    }
                }
                
                if ($this->flexconf['equalWidth']) {
                    
                    
                    $colOne = 'col';
                    $colTwo = 'col';
                    $colThree = 'col';
                    $colFour = 'col';
                    $colFive = 'col';
                    $colSix = 'col';
                    
                } else {
                    
                    foreach ($this->flexconf as $key => $value) {
                        
                        
                        if (substr($key, 0, 2) != 'ex') {
                            
                            if ($key != 'extraClass_one' || $key != 'extraClass_two' || $key != 'extraClass_three'
                                || $key != 'extraClass_four' || $key != 'extraClass_five' || $key != 'extraClass_six') {
                                
                                if ($value != '0') {
                                    if (substr($key, 0, 2) == 'xs') {
                                        if (substr($key, -3) == 'one') {
                                            $columnOne .= ' col-' . $value;
                                        }
                                        if (substr($key, -3) == 'two') {
                                            $columnTwo .= ' col-' . $value;
                                        }
                                        if (substr($key, -5) == 'three') {
                                            $columnThree .= ' col-' . $value;
                                        }
                                        if (substr($key, -4) == 'four') {
                                            $columnFour .= ' col-' . $value;
                                        }
                                        
                                        if (substr($key, -4) == 'five') {
                                            $columnFive .= ' col-' . $value;
                                        }
                                        if (substr($key, -3) == 'six') {
                                            $columnSix .= ' col-' . $value;
                                        }
                                        
                                    } else {
                                        if (substr($key, -3) == 'one') {
                                            $columnOne .= ' col-' . substr($key, 0, -4) . '-' . $value;
                                        }
                                        if (substr($key, -3) == 'two') {
                                            $columnTwo .= ' col-' . substr($key, 0, -4) . '-' . $value;
                                        }
                                        if (substr($key, -5) == 'three') {
                                            $columnThree .= ' col-' . substr($key, 0, -6) . '-' . $value;
                                        }
                                        if (substr($key, -4) == 'four') {
                                            $columnFour .= ' col-' . substr($key, 0, -5) . '-' . $value;
                                        }
                                        
                                        if (substr($key, -4) == 'five') {
                                            $columnFive .= ' col-' . substr($key, 0, -5) . '-' . $value;
                                        }
                                        if (substr($key, -3) == 'six') {
                                            $columnSix .= ' col-' . substr($key, 0, -4) . '-' . $value;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    
                    
                    $colOne = $columnOne;
                    $colTwo = $columnTwo;
                    $colThree = $columnThree;
                    $colFour = $columnFour;
                    $colFive = $columnFive;
                    $colSix = $columnSix;
                }
                
                $this->processedData['columns'] = [
                    0 => trim($colOne . $columnOneExtraClass),
                    1 => trim($colTwo . $columnTwoExtraClass),
                    2 => trim($colThree . $columnThreeExtraClass),
                    3 => trim($colFour . $columnFourExtraClass),
                    4 => trim($colFive . $columnFiveExtraClass),
                    5 => trim($colSix . $columnSixExtraClass)
                
                
                ];
                
                
            }
            
            $class = self::getGeClass();
            ##############################################################################################################################################
        }
            return $this->processedData;
    }
    
    
    /**
     * Returns the CSS-class for gridelements
     *
     * @return string
     */
    protected function getGeClass()
    {
        
        /**
         * CType: Gridelements
         */
        if ($this->processorConfiguration['cType']) {
            $class = 'ge ge_' . $this->processedData['data']['tx_gridelements_backend_layout'];
        } else {
            $class = '';
        }
        
        /**
         * Grid
         */
        if ($this->processedData['data']['tx_gridelements_backend_layout'] == '1-cols'
            || $this->processedData['data']['tx_gridelements_backend_layout'] == '2-cols'
            || $this->processedData['data']['tx_gridelements_backend_layout'] == '3-cols'
            || $this->processedData['data']['tx_gridelements_backend_layout'] == '4-cols'
        ) {
            $class .= $this->flexconf['noGutters'] ? ' no-gutters' : '';
            $class .= $this->flexconf['equalHeight'] ? ' row-eq-height' : '';
        }
        
        return trim($class);
    }
    
    
}
