<?php
defined('TYPO3_MODE') || die();

/***************
 * Add default RTE configuration
 */
$GLOBALS['TYPO3_CONF_VARS']['RTE']['Presets'][$_EXTKEY] = 'EXT:' . $_EXTKEY . '/Configuration/RTE/amds_bear.yaml';


///***
// * Set configuration for realurl Autoconfig
// */

if (\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::isLoaded('realurl')) {
    $GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['ext/realurl/class.tx_realurl_autoconfgen.php']['extensionConfiguration'][$_EXTKEY] =
        \AmadeusAgentur\Bear\RealUrlAutoConfiguration::class . '->addBearUrlConfig';
}

// UserTS
\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addUserTSConfig(
    '<INCLUDE_TYPOSCRIPT: source="FILE:EXT:' . $_EXTKEY . '/Configuration/TSconfig/User.tsconfig">'
);


\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addPageTSConfig(
    '<INCLUDE_TYPOSCRIPT: source="FILE:EXT:' . $_EXTKEY . '/Configuration/PageTS/Mod/Wizards/NewContentElement.tsconfig">'
);


/***************
 * Register Icons
 */
$iconRegistry = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance(\TYPO3\CMS\Core\Imaging\IconRegistry::class);

$iconsContentElements = [
    'alert',
    'hero',
    'menucard',
    'teaserbox',
    'ge-1col',
    'ge-2col',
    'ge-3col',
    'ge-4col',
    'ge-5col',
    'ge-flexbox'
];
foreach ($iconsContentElements as $icon) {
    $iconRegistry->registerIcon(
        'tx_amdsbear_' . $icon,
        \TYPO3\CMS\Core\Imaging\IconProvider\SvgIconProvider::class,
        ['source' => 'EXT:' . $_EXTKEY . '/Resources/Public/Icons/ContentElements/' . $icon . '.svg']
    );
}


$iconsBackendLayouts = [
    'default',
    'frontpage',
    'heroless',
    'jumbotron-sidebar-left',
    'jumbotron-sidebar-right',
    'sidebar-left',
    'sidebar-right',
];
foreach ($iconsBackendLayouts as $icon) {
    $iconRegistry->registerIcon(
        'tx_amdsbear_' . $icon,
        \TYPO3\CMS\Core\Imaging\IconProvider\SvgIconProvider::class,
        ['source' => 'EXT:' . $_EXTKEY . '/Resources/Public/Icons/BackendLayouts/' . $icon . '.svg']
    );
}



/***************
 * BE login window styling
 */

if (TYPO3_MODE === 'BE') {
    $signalSlotDispatcher = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance(\TYPO3\CMS\Extbase\SignalSlot\Dispatcher::class);

    /**
     * Add backend styling
     */
    $signalSlotDispatcher->connect(
        \TYPO3\CMS\Extensionmanager\Service\ExtensionManagementService::class,
        'hasInstalledExtensions',
        \AmadeusAgentur\Bear\Service\BrandingService::class,
        'setBackendStyling'
    );

}




/***************
 * Disable Deprecation Log on Production
 */

if(\TYPO3\CMS\Core\Utility\GeneralUtility::getApplicationContext()->isProduction()) {
    $GLOBALS['TYPO3_CONF_VARS']['LOG']['TYPO3']['CMS']['deprecations']['writerConfiguration'][\TYPO3\CMS\Core\Log\LogLevel::NOTICE] = [];
}
