<?php

namespace AmadeusAgentur\Bear\Slots;


use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;

/**
 * Class TCAOverride
 */
class TCAOverride
{
    /**
     * Function which may process data created / registered by extTables
     * scripts (f.e. modifying TCA data of all extensions)
     *
     * @param array $tca
     *
     * @return array
     */
    public function processData($tca)
    {
        $tca = $this->overrideGridElements($tca);
        
        // Move the local $tca to global variable to use general modification functions like addToAllTCAtypes
        $GLOBALS['TCA'] = $tca;
        
        ExtensionManagementUtility::addToAllTCAtypes('tt_content', 'recursive', 'shortcut', 'after:records');
        ExtensionManagementUtility::addToAllTCAtypes(
            'tt_content',
            '--div--;amadeus,tx_amdsbear_container,tx_amdsbear_header_position,tx_amdsbear_context_classes,tx_amdsbear_extra_class'
        
        );
        
        // return the modified global TCA definition
        return [$GLOBALS['TCA']];
    }
    
    private function overrideGridElements($tca)
    {
        $tca['tt_content']['types']['gridelements_pi1']['showitem'] = '
            --palette--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:palette.general;general,
            --palette--;;headers,
            tx_gridelements_backend_layout,
            pi_flexform,
            tx_gridelements_children,
            --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.appearance,
            --palette--;;frames,
            --palette--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:palette.appearanceLinks;appearanceLinks,
            assets,
            --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:language,
            --palette--;;language,
            --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:access,
            --palette--;;hidden,
            --palette--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:palette.access;access,
            --div--;LLL:EXT:core/Resources/Private/Language/locallang_tca.xlf:sys_category.tabs.category,
            categories,
            --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:notes,rowDescription
        ';
        return $tca;
    }
}
