<?php
namespace AmadeusAgentur\AmdsRatecalc\Tests\Unit\Domain\Model;

/**
 * Test case.
 *
 * @author Jan-Frederic Schubert <jan-frederic.schubert@amadeus-agentur.com>
 */
class TarifTest extends \TYPO3\TestingFramework\Core\Unit\UnitTestCase
{
    /**
     * @var \AmadeusAgentur\AmdsRatecalc\Domain\Model\Tarif
     */
    protected $subject = null;

    protected function setUp()
    {
        parent::setUp();
        $this->subject = new \AmadeusAgentur\AmdsRatecalc\Domain\Model\Tarif();
    }

    protected function tearDown()
    {
        parent::tearDown();
    }

    /**
     * @test
     */
    public function getNameReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getName()
        );
    }

    /**
     * @test
     */
    public function setNameForStringSetsName()
    {
        $this->subject->setName('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'name',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getRatedescriptionReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getRatedescription()
        );
    }

    /**
     * @test
     */
    public function setRatedescriptionForStringSetsRatedescription()
    {
        $this->subject->setRatedescription('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'ratedescription',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getBasicChargeReturnsInitialValueForFloat()
    {
        self::assertSame(
            0.0,
            $this->subject->getBasicCharge()
        );
    }

    /**
     * @test
     */
    public function setBasicChargeForFloatSetsBasicCharge()
    {
        $this->subject->setBasicCharge(3.14159265);

        self::assertAttributeEquals(
            3.14159265,
            'basicCharge',
            $this->subject,
            '',
            0.000000001
        );
    }

    /**
     * @test
     */
    public function getUnitPriceReturnsInitialValueForFloat()
    {
        self::assertSame(
            0.0,
            $this->subject->getUnitPrice()
        );
    }

    /**
     * @test
     */
    public function setUnitPriceForFloatSetsUnitPrice()
    {
        $this->subject->setUnitPrice(3.14159265);

        self::assertAttributeEquals(
            3.14159265,
            'unitPrice',
            $this->subject,
            '',
            0.000000001
        );
    }

    /**
     * @test
     */
    public function getPrePaidReturnsInitialValueForBool()
    {
        self::assertSame(
            false,
            $this->subject->getPrePaid()
        );
    }

    /**
     * @test
     */
    public function setPrePaidForBoolSetsPrePaid()
    {
        $this->subject->setPrePaid(true);

        self::assertAttributeEquals(
            true,
            'prePaid',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getMaxKWHReturnsInitialValueForInt()
    {
        self::assertSame(
            0,
            $this->subject->getMaxKWH()
        );
    }

    /**
     * @test
     */
    public function setMaxKWHForIntSetsMaxKWH()
    {
        $this->subject->setMaxKWH(12);

        self::assertAttributeEquals(
            12,
            'maxKWH',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getMinKWHReturnsInitialValueForInt()
    {
        self::assertSame(
            0,
            $this->subject->getMinKWH()
        );
    }

    /**
     * @test
     */
    public function setMinKWHForIntSetsMinKWH()
    {
        $this->subject->setMinKWH(12);

        self::assertAttributeEquals(
            12,
            'minKWH',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getInsideAreaReturnsInitialValueForBool()
    {
        self::assertSame(
            false,
            $this->subject->getInsideArea()
        );
    }

    /**
     * @test
     */
    public function setInsideAreaForBoolSetsInsideArea()
    {
        $this->subject->setInsideArea(true);

        self::assertAttributeEquals(
            true,
            'insideArea',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getTarifTypeReturnsInitialValueForInt()
    {
        self::assertSame(
            0,
            $this->subject->getTarifType()
        );
    }

    /**
     * @test
     */
    public function setTarifTypeForIntSetsTarifType()
    {
        $this->subject->setTarifType(12);

        self::assertAttributeEquals(
            12,
            'tarifType',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getDetailPageReturnsInitialValueForInt()
    {
        self::assertSame(
            0,
            $this->subject->getDetailPage()
        );
    }

    /**
     * @test
     */
    public function setDetailPageForIntSetsDetailPage()
    {
        $this->subject->setDetailPage(12);

        self::assertAttributeEquals(
            12,
            'detailPage',
            $this->subject
        );
    }
}
