<?php
namespace AmadeusAgentur\AmdsRatecalc\Tests\Unit\Controller;

/**
 * Test case.
 *
 * @author Jan-Frederic Schubert <jan-frederic.schubert@amadeus-agentur.com>
 */
class TarifControllerTest extends \TYPO3\TestingFramework\Core\Unit\UnitTestCase
{
    /**
     * @var \AmadeusAgentur\AmdsRatecalc\Controller\TarifController
     */
    protected $subject = null;

    protected function setUp()
    {
        parent::setUp();
        $this->subject = $this->getMockBuilder(\AmadeusAgentur\AmdsRatecalc\Controller\TarifController::class)
            ->setMethods(['redirect', 'forward', 'addFlashMessage'])
            ->disableOriginalConstructor()
            ->getMock();
    }

    protected function tearDown()
    {
        parent::tearDown();
    }

    /**
     * @test
     */
    public function listActionFetchesAllTarifsFromRepositoryAndAssignsThemToView()
    {

        $allTarifs = $this->getMockBuilder(\TYPO3\CMS\Extbase\Persistence\ObjectStorage::class)
            ->disableOriginalConstructor()
            ->getMock();

        $tarifRepository = $this->getMockBuilder(\::class)
            ->setMethods(['findAll'])
            ->disableOriginalConstructor()
            ->getMock();
        $tarifRepository->expects(self::once())->method('findAll')->will(self::returnValue($allTarifs));
        $this->inject($this->subject, 'tarifRepository', $tarifRepository);

        $view = $this->getMockBuilder(\TYPO3\CMS\Extbase\Mvc\View\ViewInterface::class)->getMock();
        $view->expects(self::once())->method('assign')->with('tarifs', $allTarifs);
        $this->inject($this->subject, 'view', $view);

        $this->subject->listAction();
    }
}
