<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:amds_ratecalc/Resources/Private/Language/locallang_db.xlf:tx_amdsratecalc_domain_model_tarif',
        'label' => 'name',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'cruser_id' => 'cruser_id',
        'versioningWS' => true,
        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'name,ratedescription',
        'iconfile' => 'EXT:amds_ratecalc/Resources/Public/Icons/tx_amdsratecalc_domain_model_tarif.gif'
    ],
    'interface' => [
        'showRecordFieldList' => 'sys_language_uid, l10n_parent, l10n_diffsource, hidden, name, ratedescription, basic_charge, unit_price, pre_paid, max_k_w_h, min_k_w_h, inside_area, tarif_type, detail_page',
    ],
    'types' => [
        '1' => ['showitem' => 'sys_language_uid, l10n_parent, l10n_diffsource, hidden, name, ratedescription, basic_charge, unit_price, pre_paid, max_k_w_h, min_k_w_h, inside_area, tarif_type, detail_page, --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.access, starttime, endtime'],
    ],
    'columns' => [
        'sys_language_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'special' => 'languages',
                'items' => [
                    [
                        'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.allLanguages',
                        -1,
                        'flags-multiple'
                    ]
                ],
                'default' => 0,
            ],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'default' => 0,
                'items' => [
                    ['', 0],
                ],
                'foreign_table' => 'tx_amdsratecalc_domain_model_tarif',
                'foreign_table_where' => 'AND {#tx_amdsratecalc_domain_model_tarif}.{#pid}=###CURRENT_PID### AND {#tx_amdsratecalc_domain_model_tarif}.{#sys_language_uid} IN (-1,0)',
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],
        't3ver_label' => [
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.versionLabel',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'max' => 255,
            ],
        ],
        'hidden' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.visible',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        0 => '',
                        1 => '',
                        'invertStateDisplay' => true
                    ]
                ],
            ],
        ],
        'starttime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'eval' => 'datetime,int',
                'default' => 0,
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],
        'endtime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'eval' => 'datetime,int',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038)
                ],
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],

        'name' => [
            'exclude' => true,
            'label' => 'LLL:EXT:amds_ratecalc/Resources/Private/Language/locallang_db.xlf:tx_amdsratecalc_domain_model_tarif.name',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'ratedescription' => [
            'exclude' => true,
            'label' => 'LLL:EXT:amds_ratecalc/Resources/Private/Language/locallang_db.xlf:tx_amdsratecalc_domain_model_tarif.ratedescription',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim'
            ]
        ],
        'basic_charge' => [
            'exclude' => true,
            'label' => 'LLL:EXT:amds_ratecalc/Resources/Private/Language/locallang_db.xlf:tx_amdsratecalc_domain_model_tarif.basic_charge',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'double2'
            ]
        ],
        'unit_price' => [
            'exclude' => true,
            'label' => 'LLL:EXT:amds_ratecalc/Resources/Private/Language/locallang_db.xlf:tx_amdsratecalc_domain_model_tarif.unit_price',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'double2'
            ]
        ],
        'pre_paid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:amds_ratecalc/Resources/Private/Language/locallang_db.xlf:tx_amdsratecalc_domain_model_tarif.pre_paid',
            'config' => [
                'type' => 'check',
                'items' => [
                    '1' => [
                        '0' => 'LLL:EXT:lang/locallang_core.xlf:labels.enabled'
                    ]
                ],
                'default' => 0,
            ]
        ],
        'max_k_w_h' => [
            'exclude' => true,
            'label' => 'LLL:EXT:amds_ratecalc/Resources/Private/Language/locallang_db.xlf:tx_amdsratecalc_domain_model_tarif.max_k_w_h',
            'config' => [
                'type' => 'input',
                'size' => 4,
                'eval' => 'int'
            ]
        ],
        'min_k_w_h' => [
            'exclude' => true,
            'label' => 'LLL:EXT:amds_ratecalc/Resources/Private/Language/locallang_db.xlf:tx_amdsratecalc_domain_model_tarif.min_k_w_h',
            'config' => [
                'type' => 'input',
                'size' => 4,
                'eval' => 'int'
            ]
        ],
        'inside_area' => [
            'exclude' => true,
            'label' => 'LLL:EXT:amds_ratecalc/Resources/Private/Language/locallang_db.xlf:tx_amdsratecalc_domain_model_tarif.inside_area',
            'config' => [
                'type' => 'check',
                'items' => [
                    '1' => [
                        '0' => 'LLL:EXT:lang/locallang_core.xlf:labels.enabled'
                    ]
                ],
                'default' => 0,
            ]
        ],
        'tarif_type' => [
            'exclude' => true,
            'label' => 'LLL:EXT:amds_ratecalc/Resources/Private/Language/locallang_db.xlf:tx_amdsratecalc_domain_model_tarif.tarif_type',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',

                'items' => [
                    ['-- Label --', 0],
                ],

                'size' => 1,
                'maxitems' => 1,
                'eval' => ''
            ],
        ],
        'detail_page' => [
            'exclude' => true,
            'label' => 'LLL:EXT:amds_ratecalc/Resources/Private/Language/locallang_db.xlf:tx_amdsratecalc_domain_model_tarif.detail_page',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectTree',
                'items' => [
                    ['-- Bitte auswählen --', 0],
                ],
                'foreign_table' => 'pages',
                'size' => 20,
                'maxitems' => 1,
                'eval' => '',
                'treeConfig' => [
                    'parentField' => 'pid',
                    'appearance' => [
                        'expandAll' => true,
                        'showHeader' => true,
                    ],
                ],
            ],
        ],
    ],
];
