/*! Select2 4.0.8 | https://github.com/select2/select2/blob/master/LICENSE.md */

!function () {
    if (jQuery && jQuery.fn && jQuery.fn.select2 && jQuery.fn.select2.amd) var e = jQuery.fn.select2.amd;
    e.define("select2/i18n/de", [], function () {
        return {
            errorLoading: function () {
                return "Die Ergebnisse konnten nicht geladen werden."
            }, inputTooLong: function (e) {
                return "Bitte " + (e.input.length - e.maximum) + " Zeichen weniger eingeben"
            }, inputTooShort: function (e) {
                return "Bitte " + (e.minimum - e.input.length) + " Zeichen mehr eingeben"
            }, loadingMore: function () {
                return "Lade mehr Ergebnisse…"
            }, maximumSelected: function (e) {
                var n = "Sie können nur " + e.maximum + " Eintr";
                return 1 === e.maximum ? n += "ag" : n += "äge", n += " auswählen"
            }, noResults: function () {
                return "Keine Übereinstimmungen gefunden"
            }, searching: function () {
                return "Suche…"
            }, removeAllItems: function () {
                return "Entferne alle Gegenstände"
            }
        }
    }), e.define, e.require
}();

function tarifHide() {
    tarife.hide();
}

function calcRates() {

    $usage = parseInt($('#KWHusage').val());

    // WILL get you 1 or 0;
    $insideArea = !!$($('#PLZ').select2('data')[0].element).data('insidearea');

    console.log($insideArea);

    if (!!$usage) {
        tarifHide();
        resultscontainer.classList.add('has-calculation');
    } else return;


    $tarifType = $('input[name=tarifType]:checked').val();

    if (!Date.now) {
        Date.now = function() { return new Date().getTime(); }
    }

    var currentTime = Math.floor((Date.now() / 1000));

    if ((currentTime >= 1593561600) && (currentTime <= 1609459200)) {
        var tarifTaxModifier = 1.16;
    }
    else {
        var tarifTaxModifier = 1.19;
    }

    var displayTaxModifier = tarifTaxModifier * 100 - 100;

    tarife.each(function (index, tarif) {

        tarif = $(tarif);

        var min = (tarif.data('minkwh') === 0 || $usage >= tarif.data('minkwh'));
        var max = (tarif.data('maxkwh') === 0 || $usage <= tarif.data('maxkwh'));


        if (tarif.data('type') == $tarifType && tarif.data('area') == $insideArea) {

            if (min && max) {

                tarif.show();
                var usageCost = $usage * (tarif.data('unitprice')/ 100);
                var cost = usageCost + tarif.data('basiccharge');



                cost *= tarifTaxModifier;

                var monthlyFee = (cost / 12).toLocaleString('de-DE', {style: 'currency', currency: 'EUR'});
                var prePayment = (cost / 11).toLocaleString('de-DE', {style: 'currency', currency: 'EUR'});

                if (cheapest.elem == null || cost < cheapest.cost) {
                    cheapest.elem = tarif;
                    cheapest.cost = cost;
                }

                tarif.find('.basics.unitPrice').find('.value').text((tarif.data('unitprice') * tarifTaxModifier).toLocaleString('de-DE',{maximumFractionDigits:2}) + ' Cent');
                tarif.find('.basics.basicCharge').find('.value').text((tarif.data('basiccharge') * tarifTaxModifier).toLocaleString('de-DE', {style: 'currency', currency: 'EUR'}));

                tarif.find('span.cost').text(cost.toLocaleString('de-DE', {style: 'currency', currency: 'EUR'}));
                tarif.find('span.monthly').text(monthlyFee);
                tarif.find('span.prepayment').text(prePayment);
                tarif.find('span.usage').text($usage);
                tarif.find('span.taxmodel').text("Alle Preise inkl. " + displayTaxModifier.toFixed(0) + "%  " + ( $tarifType == 1 ? " USt" : " MwSt"));

            }
        }
    });

    $('.card-rate--recommended').removeClass('card-rate--recommended');

    if (cheapest.elem !== null) cheapest.elem.addClass('card-rate--recommended');

    sortCheapest();
}

function sortCheapest() {
    var parent = document.querySelector('.ratecalc-results.has-calculation');


    [].slice.call(parent.children)
        .sort(function (a, b) {
            return getPrice(a) - getPrice(b);
        }).forEach(function (ele) {
        parent.appendChild(ele);
    })
}

function getPrice(ele) {

    // We have to replace the commatas and dots with nothing
    // it doesn't matter if we a calculate a order of magnitute down

    return Number(ele
            .querySelector('span.cost')
            .textContent
            .replace('.', '')
            .replace(',', '')
            .replace(/[^\d.]+/g, ''))
        || 0;
}


var tarife;
var resultscontainer = document.getElementById('resultsContainer');
var selectBox = document.getElementById("PLZ")
var cheapest = {
    elem: null,
    cost: null
};


$(function (evt) {
    if (selectBox) {

        var preselected = selectBox.getAttribute('data-preselected');
        if (preselected != '') {
            $('#PLZ').val(preselected);
        }

        $('#PLZ').select2({
            placeholder: "PLZ der Verbrauchsstelle"
        });
    }

    if (resultscontainer) {
        tarife = $('.card-rate');
        $('#showRatesBtn').on('click', function (evt) {

            evt.preventDefault();
            cheapest = {
                elem: null,
                cost: null

            };

            calcRates();

            $('html, body').stop().animate({
                'scrollTop': resultscontainer.offsetTop - 100
            }, 500, 'swing');

        });
        setTimeout(function () {
            $('#showRatesBtn').trigger('click')
        }, 15);
    }
});

