<?php

namespace AmadeusAgentur\AmdsRatecalc\Controller;

use AmadeusAgentur\AmdsRatecalc\Domain\Repository\TarifRepository;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;


/***
 *
 * This file is part of the "Tarifrechner" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2019 Jan-Frederic Schubert <jan-frederic.schubert@amadeus-agentur.com>, Amadeus Agentur
 *
 ***/

class TarifController extends ActionController
{
    protected $tarifRepository;

    public function injectTarifRepository(TarifRepository $tarifRepo):void {
        $this->tarifRepository = $tarifRepo;
    }

    /**
     * action list
     * 
     * @return void
     */
    public function listAction()
    {
        $contentObject = $this->configurationManager->getContentObject();
        $tarifPids = explode(',',$contentObject->data['pages']);



        $tarife = $this->tarifRepository->findByPid($tarifPids);


        $this->view->assign('pageId',$contentObject->data);
        $this->view->assign('examplePLZ',$_POST['plz'] ?? null);
        $this->view->assign('exampleUsage',$_POST['kwhusage'] ?? null);
        $this->view->assign('exampleType',$_POST['tarifType'] ?? 0);
        $this->view->assign('tarife', $tarife);
    }

    /**
     * action teaser
     * 
     * @return void
     */
    public function teaserAction()
    {
        $contentObject = $this->configurationManager->getContentObject();
        $resultPage = $contentObject->data['pages'];
        $this->view->assign('uid',$contentObject->data["uid"]);

        $this->view->assign('resultPage', $resultPage);
        $this->view->assign('examplePLZ',$_POST['plz'] ?? null);
        $this->view->assign('exampleUsage',$_POST['kwhusage'] ?? null);
        $this->view->assign('exampleType',$_POST['tarifType'] ?? 0);
    }
}
