<?php
namespace AmadeusAgentur\AmdsRatecalc\Tests\Unit\Domain\Model;

/**
 * Test case.
 *
 * @author Jan-Frederic Schubert <jan-frederic.schubert@amadeus-agentur.com>
 */
class TarifTest extends \TYPO3\TestingFramework\Core\Unit\UnitTestCase
{
    /**
     * @var \AmadeusAgentur\AmdsRatecalc\Domain\Model\Tarif
     */
    protected $subject = null;

    protected function setUp()
    {
        parent::setUp();
        $this->subject = new \AmadeusAgentur\AmdsRatecalc\Domain\Model\Tarif();
    }

    protected function tearDown()
    {
        parent::tearDown();
    }

    /**
     * @test
     */
    public function getNameReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getName()
        );
    }

    /**
     * @test
     */
    public function setNameForStringSetsName()
    {
        $this->subject->setName('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'name',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getBasicChargeReturnsInitialValueForFloat()
    {
        self::assertSame(
            0.0,
            $this->subject->getBasicCharge()
        );
    }

    /**
     * @test
     */
    public function setBasicChargeForFloatSetsBasicCharge()
    {
        $this->subject->setBasicCharge(3.14159265);

        self::assertAttributeEquals(
            3.14159265,
            'basicCharge',
            $this->subject,
            '',
            0.000000001
        );
    }

    /**
     * @test
     */
    public function getUnitPriceReturnsInitialValueForFloat()
    {
        self::assertSame(
            0.0,
            $this->subject->getUnitPrice()
        );
    }

    /**
     * @test
     */
    public function setUnitPriceForFloatSetsUnitPrice()
    {
        $this->subject->setUnitPrice(3.14159265);

        self::assertAttributeEquals(
            3.14159265,
            'unitPrice',
            $this->subject,
            '',
            0.000000001
        );
    }

    /**
     * @test
     */
    public function getPrePaidReturnsInitialValueForBool()
    {
        self::assertSame(
            false,
            $this->subject->getPrePaid()
        );
    }

    /**
     * @test
     */
    public function setPrePaidForBoolSetsPrePaid()
    {
        $this->subject->setPrePaid(true);

        self::assertAttributeEquals(
            true,
            'prePaid',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getMaxKWHReturnsInitialValueForFloat()
    {
        self::assertSame(
            0.0,
            $this->subject->getMaxKWH()
        );
    }

    /**
     * @test
     */
    public function setMaxKWHForFloatSetsMaxKWH()
    {
        $this->subject->setMaxKWH(3.14159265);

        self::assertAttributeEquals(
            3.14159265,
            'maxKWH',
            $this->subject,
            '',
            0.000000001
        );
    }

    /**
     * @test
     */
    public function getMinKWHReturnsInitialValueForFloat()
    {
        self::assertSame(
            0.0,
            $this->subject->getMinKWH()
        );
    }

    /**
     * @test
     */
    public function setMinKWHForFloatSetsMinKWH()
    {
        $this->subject->setMinKWH(3.14159265);

        self::assertAttributeEquals(
            3.14159265,
            'minKWH',
            $this->subject,
            '',
            0.000000001
        );
    }
}
