function calcRates() {

    $usage = parseInt($('#KWHusage').val());

    container.html('');

    $('<div>').addClass('usage').html('Ihr Verbrauch:<span class="actualUsage">' + $usage + '</span>').appendTo(container)

    var rateContainer = $('<div>').addClass('rateContainer').appendTo(container);


    tarife.forEach((tarif) => {

        var min = (tarif.minKWH === 0 || $usage >= $tarif.minkWH);
        var max = (tarif.maxKWH === 0 || $usage <= tarif.maxKWH);


        if (min && max) {
            console.log(tarif.name);

            var usageCost = $usage * (tarif.unitPrice / 100);
            var cost = usageCost + (tarif.basicCharge * 12);

            var monthlyFee = (cost / 12).toFixed(2);
            var prePayment = (cost / 11).toFixed(2);

            $('<div>').addClass("rate").html(
                '<div class="rate-name">' +
                tarif.name +
                '</div>' +

                '<div class="unitPrice"><span class="unitPrice">' + tarif.unitPrice + '</span> ct/KWh</div>' +
                '<div class="basicCharge">Grundebühr: <span class="basicCharge">' + tarif.basicCharge + '</span> €/mtl.</div>' +

                '<div class="totalCosts">Gesamtkosten / Jahr: <span class="cost">' + cost.toFixed(2) + '</span> €</div>' +
                '<div class="monthlyCosts">Mtl. Rate: <span class="monthly">' + monthlyFee + '</span> €</div>' +
                '<div class="prePaymentCosts">Abschlag: <span class="prepayment">' + prePayment + '</span> €</div>' +

                ''
            ).appendTo(container);
        }
    });
}

var container = $('.amds-rate-calc .resultsContainer');

$((evt) => {
    $('#showRatesBtn').on('click', calcRates)
});


if (!Array.prototype.forEach) {

    Array.prototype.forEach = function (callback, thisArg) {

        var T, k;
        if (this == null) {
            throw new TypeError(' this is null or not defined');
        }
        // 1. Let O be the result of calling ToObject passing the |this| value as the argument.
        var O = Object(this);
        // 2. Let lenValue be the result of calling the Get internal method of O with the argument "length".
        // 3. Let len be ToUint32(lenValue).
        var len = O.length >>> 0;
        // 4. If IsCallable(callback) is false, throw a TypeError exception.
        // See: http://es5.github.com/#x9.11
        if (typeof callback !== "function") {
            throw new TypeError(callback + ' is not a function');
        }
        // 5. If thisArg was supplied, let T be thisArg; else let T be undefined.
        if (arguments.length > 1) {
            T = thisArg;
        }
        // 6. Let k be 0
        k = 0;
        // 7. Repeat, while k < len
        while (k < len) {
            var kValue;
            // a. Let Pk be ToString(k).
            //   This is implicit for LHS operands of the in operator
            // b. Let kPresent be the result of calling the HasProperty internal method of O with argument Pk.
            //   This step can be combined with c
            // c. If kPresent is true, then
            if (k in O) {
                // i. Let kValue be the result of calling the Get internal method of O with argument Pk.
                kValue = O[k];
                // ii. Call the Call internal method of callback with T as the this value and
                // argument list containing kValue, k, and O.
                callback.call(T, kValue, k, O);
            }
            // d. Increase k by 1.
            k++;
        }
        // 8. return undefined
    };
}
