<?php
namespace AmadeusAgentur\AmdsRatecalc\Domain\Model;


/***
 *
 * This file is part of the "Tarifrechner" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2019 Jan-Frederic Schubert <jan-frederic.schubert@amadeus-agentur.com>, Amadeus Agentur
 *
 ***/
/**
 * Tarif
 */
class Tarif extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{

    /**
     * basicCharge
     * 
     * @var float
     */
    protected $basicCharge = 0.0;

    /**
     * unitPrice
     * 
     * @var float
     */
    protected $unitPrice = 0.0;

    /**
     * prePaid
     * 
     * @var bool
     */
    protected $prePaid = false;

    /**
     * name
     * 
     * @var string
     */
    protected $name = '';

    /**
     * maxKWH
     * 
     * @var float
     */
    protected $maxKWH = 0.0;

    /**
     * minKWH
     * 
     * @var float
     */
    protected $minKWH = 0.0;

    /**
     * Returns the basicCharge
     * 
     * @return float $basicCharge
     */
    public function getBasicCharge()
    {
        return $this->basicCharge;
    }

    /**
     * Sets the basicCharge
     * 
     * @param float $basicCharge
     * @return void
     */
    public function setBasicCharge($basicCharge)
    {
        $this->basicCharge = $basicCharge;
    }

    /**
     * Returns the unitPrice
     * 
     * @return float $unitPrice
     */
    public function getUnitPrice()
    {
        return $this->unitPrice;
    }

    /**
     * Sets the unitPrice
     * 
     * @param float $unitPrice
     * @return void
     */
    public function setUnitPrice($unitPrice)
    {
        $this->unitPrice = $unitPrice;
    }

    /**
     * Returns the prePaid
     * 
     * @return bool $prePaid
     */
    public function getPrePaid()
    {
        return $this->prePaid;
    }

    /**
     * Sets the prePaid
     * 
     * @param bool $prePaid
     * @return void
     */
    public function setPrePaid($prePaid)
    {
        $this->prePaid = $prePaid;
    }

    /**
     * Returns the boolean state of prePaid
     * 
     * @return bool
     */
    public function isPrePaid()
    {
        return $this->prePaid;
    }

    /**
     * Returns the name
     * 
     * @return string $name
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     * 
     * @param string $name
     * @return void
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * Returns the maxKWH
     * 
     * @return float $maxKWH
     */
    public function getMaxKWH()
    {
        return $this->maxKWH;
    }

    /**
     * Sets the maxKWH
     * 
     * @param float $maxKWH
     * @return void
     */
    public function setMaxKWH($maxKWH)
    {
        $this->maxKWH = $maxKWH;
    }

    /**
     * Returns the minKWH
     * 
     * @return float $minKWH
     */
    public function getMinKWH()
    {
        return $this->minKWH;
    }

    /**
     * Sets the minKWH
     * 
     * @param float $minKWH
     * @return void
     */
    public function setMinKWH($minKWH)
    {
        $this->minKWH = $minKWH;
    }
}
