function calcRates() {

    $usage = parseInt($('#KWHusage').val());

    $insideArea = $('#PLZ').val();

    if($insideArea == 98617 || $insideArea == 98547) $insideArea = 1;
    else $insideArea = 0;

    tarife.hide();

    $tarifType = $('input[name=tarifType]:checked').val();


    tarife.each((index, tarif) => {

        tarif = $(tarif);


        var min = (tarif.data('minkwh') === 0 || $usage >= tarif.data('minkwh'));
        var max = (tarif.data('maxkwh') === 0 || $usage <= tarif.data('maxkwh'));


        // console.log(tarif.data('tariftype') , $tarifType , tarif.data('insidearea') , $insideArea)


        if (tarif.data('tariftype') == $tarifType && tarif.data('insidearea') == $insideArea) {
            // console.log("right type and area");


            if (min && max) {
                // console.log("and right kwh values");
                tarif.show();
                var usageCost = $usage * (tarif.data('unitprice') / 100);
                var cost = usageCost + (tarif.data('basiccharge') * 12);

                var monthlyFee = (cost / 12).toFixed(2);
                var prePayment = (cost / 11).toFixed(2);

                // console.log(cost);
                tarif.find('span.cost').text(cost.toFixed(2));
                tarif.find('span.monthly').text(monthlyFee);
                tarif.find('span.prepayment').text(prePayment);
            }
        }
    });
}

var tarife;

$((evt) => {
    tarife = $('.rate.card');
    tarife.hide();

    $('#showRatesBtn').on('click', calcRates)
});