<?php

namespace Amadeus\Plugin\Rechtstexte;

use Amadeus\Core\Page\Settings;

class OptionPage
{
    private $settings_api;

    function __construct()
    {

        $this->settings_api = new Settings();
        add_action('admin_init', [$this, 'onAdminInit']);
        add_action('admin_menu', [$this, 'onAdminMenu']);
    }

    function onAdminInit()
    {
//set the settings
        $this->settings_api->set_sections($this->getSettingsSections());
        $this->settings_api->set_fields($this->getSettingsFields());
//initialize settings
        $this->settings_api->admin_init();
    }

    function onAdminMenu()
    {
        add_submenu_page('amadeus-core-settings', 'Rechtstexte', 'Rechtstexte', 'delete_posts', 'amadeus-legal-settings', [$this, 'getOptionPage']);
    }

    function getSettingsSections()
    {
        $sections = [
            [
                'id' => 'amadeus_impressum',
                'title' => __('Impressum', 'amadeus')
            ],
            [
                'id' => 'amadeus_datenschutz',
                'title' => __('Datenschutz', 'amadeus')
            ]
        ];
        return $sections;
    }

    /**
     * Returns all the settings fields
     *
     * @return array settings fields
     */
    function getSettingsFields()
    {
        $settings_fields = [
            'amadeus_datenschutz' => [
                [
                    'name' => 'law',
                    'label' => __('Verwantwortliche Stelle', 'amadeus'),
                    'desc' => __('Hinweis anzeigen', 'amadeus'),
                    'type' => 'checkbox'
                ],
                [
                    'name' => 'serverlog',
                    'label' => __('Serverlog', 'amadeus'),
                    'desc' => __('Hinweis anzeigen', 'amadeus'),
                    'type' => 'checkbox'
                ],
                [
                    'name' => 'google_analytics',
                    'label' => __('Google-Analytics', 'amadeus'),
                    'desc' => __('Hinweis anzeigen', 'amadeus'),
                    'type' => 'checkbox'
                ],
                [
                    'name' => 'newsletter',
                    'label' => __('Newsletter', 'amadeus'),
                    'desc' => __('Hinweis anzeigen', 'amadeus'),
                    'type' => 'checkbox'
                ],
                [
                    'name' => 'youtube',
                    'label' => __('Youtube', 'amadeus'),
                    'desc' => __('Hinweis anzeigen', 'amadeus'),
                    'type' => 'checkbox'
                ],
                [
                    'name' => 'vimeo',
                    'label' => __('vimeo', 'amadeus'),
                    'desc' => __('Hinweis anzeigen', 'amadeus'),
                    'type' => 'checkbox'
                ],
                [
                    'name' => 'google_fonts',
                    'label' => __('Google Fonts', 'amadeus'),
                    'desc' => __('Hinweis anzeigen', 'amadeus'),
                    'type' => 'checkbox'
                ],
                [
                    'name' => 'typekit',
                    'label' => __('Typekit', 'amadeus'),
                    'desc' => __('Hinweis anzeigen', 'amadeus'),
                    'type' => 'checkbox'
                ],
                [
                    'name' => 'google_maps',
                    'label' => __('Google Maps', 'amadeus'),
                    'desc' => __('Hinweis anzeigen', 'amadeus'),
                    'type' => 'checkbox'
                ],

                [
                    'name' => 'custom_plugin',
                    'label' => __('Sonstige Plugins', 'amadeus'),
                    'placeholder' => __('<h3>Plugin</h3><p>Text</p>', 'amadeus'),
                    'type' => 'textarea'
                ],
                [
                    'name' => 'beauftragterName',
                    'label' => __('Datenschutzbeauftragter', 'amadeus'),
                    'placeholder' => __('Name + Anschrift', 'amadeus'),
                    'type' => 'textarea'
                ],

                [
                    'name' => 'beauftragterTel',
                    'label' => __('Telefon', 'amadeus'),
                    'placeholder' => __('Datenschutzbeauftrager Telefon', 'amadeus'),
                    'type' => 'text'
                ],
                [
                    'name' => 'beauftragterEMail',
                    'label' => __('E-Mail', 'amadeus'),
                    'placeholder' => __('Datenschutzbeauftrager E-Mail', 'amadeus'),
                    'type' => 'text'
                ],
            ],
            'amadeus_impressum' => [
                [
                    'name' => 'publisherAddress',
                    'label' => __('Webseitenbetreiber', 'amadeus'),
                    'desc' => __('', 'amadeus'),
                    'placeholder' => __('Komplette Anschrift', 'amadeus'),
                    'type' => 'textarea'
                ],
                [
                    'name' => 'publisherTel',
                    'label' => __('Telefon', 'amadeus'),
                    'placeholder' => __('Betreiber Telefon', 'amadeus'),
                    'type' => 'text'
                ],
                [
                    'name' => 'publisherMail',
                    'label' => __('E-Mail', 'amadeus'),
                    'placeholder' => __('Betreiber E-Mail', 'amadeus'),
                    'type' => 'text'
                ],
            ]
        ];
        return $settings_fields;
    }

    function getOptionPage()
    {
        echo '<div class="wrap">';
        $this->settings_api->show_navigation();
        $this->settings_api->show_forms();
        echo '</div>';
    }

    /**
     * Get all the pages
     *
     * @return array page names with key value pairs
     */
    function getPages()
    {
        $pages = get_pages();
        $pages_options = [];
        if ($pages) {
            foreach ($pages as $page) {
                $pages_options[$page->ID] = $page->post_title;
            }
        }
        return $pages_options;
    }
}