<?php

namespace Amadeus\Plugin\Rechtstexte;


use Amadeus\Core\PostType\PostType;
use Amadeus\Core\Page\Settings;
use Amadeus\Core\Shortcode;
use Amadeus\Core\Traits\TimberLocation;
use Amadeus\Core\Traits\Updater;
use Timber\Timber;

class Main
{
    use Updater;
    use TimberLocation;

    private static $PLUGIN_URL = '';

    public static function init($main_path = __FILE__)
    {
        self::$PLUGIN_PATH = plugin_dir_path($main_path);
        self::$PLUGIN_URL = plugins_url('',$main_path);



        self::registerUpdater();
        self::registerTimberLocation();

        new OptionPage();

        //CookieNotice::init();
        self::dataProtectionShortCode();

    }

    private static function dataProtectionShortCode()
    {
        $sc = new Shortcode("datenschutz", function ($params) {


            $context['datenschutz'] = get_option('amadeus_datenschutz');
            $context['impressum'] = get_option('amadeus_impressum');


            $r = Timber::compile("datenschutz_11.twig", $context);

            return do_shortcode($r);
        });
    }

    public static function getPath()
    {
        return self::$PLUGIN_PATH;
    }
    public static function getURL()
    {
        return self::$PLUGIN_URL;
    }
}
