<?php

declare(strict_types=1);

use TYPO3\CMS\Core\Information\Typo3Version;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Utility\ExtensionUtility;
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
use AmadeusAgentur\AmadeusNext\Controller\AwardController;
use AmadeusAgentur\AmadeusNext\Controller\BusinessController;
use AmadeusAgentur\AmadeusNext\Controller\CaseController;
use AmadeusAgentur\AmadeusNext\Controller\ClientController;

defined('TYPO3') or die('Access denied.');


$versionInformation = GeneralUtility::makeInstance(Typo3Version::class);
// Only include user.tsconfig if TYPO3 version is below 13 so that it is not imported twice.
if ($versionInformation->getMajorVersion() < 13) {
    ExtensionManagementUtility::addUserTSConfig(
        '@import "EXT:amadeus_next/Configuration/user.tsconfig"'
    );
}

(function () {
    
    /***************
     * Add default RTE configuration
     */
    $GLOBALS['TYPO3_CONF_VARS']['RTE']['Presets']['amadeus_next'] = 'EXT:amadeus_next/Configuration/RTE/Default.yaml';
    
    // Remove the doktypes we do not use
//    ExtensionManagementUtility::addUserTSConfig('options.pageTree.doktypesToShowInNewPageDragArea := removeFromList(7,255,199)');

    ExtensionUtility::configurePlugin(
        'amadeusNext',
        'AwardAnzahl',
        [
            AwardController::class => 'amount',
        ],
        [
            AwardController::class => '',
        ]
    );

    ExtensionUtility::configurePlugin(
        'amadeusNext',
        'AwardAuswahl',
        [
            AwardController::class => 'selection',
        ],
        [
            AwardController::class => '',
        ]
    );

    ExtensionUtility::configurePlugin(
        'amadeusNext',
        'BusinessDetail',
        [
            BusinessController::class => 'detail',
        ],
        [
            BusinessController::class => '',
        ]
    );
    
    ExtensionUtility::configurePlugin(
        'amadeusNext',
        'CaseAnzahl',
        [
            CaseController::class => 'amount',
        ],
        [
            CaseController::class => '',
        ]
    );
    
    ExtensionUtility::configurePlugin(
        'amadeusNext',
        'CaseAuswahl',
        [
            CaseController::class => 'selection',
        ],
        [
            CaseController::class => '',
        ]
    );

    ExtensionUtility::configurePlugin(
        'amadeusNext',
        'CaseKategorie',
        [
            CaseController::class => 'category',
        ],
        [
            CaseController::class => '',
        ]
    );
    
    ExtensionUtility::configurePlugin(
        'amadeusNext',
        'KundenAnzahl',
        [
            ClientController::class => 'amount',
        ],
        [
            ClientController::class => '',
        ]
    );
    
    ExtensionUtility::configurePlugin(
        'amadeusNext',
        'KundenAuswahl',
        [
            ClientController::class => 'selection',
        ],
        [
            ClientController::class => '',
        ]
    );

    ExtensionUtility::configurePlugin(
        'amadeusNext',
        'KundenBranche',
        [
            ClientController::class => 'category',
        ],
        [
            ClientController::class => '',
        ]
    );

    ExtensionUtility::configurePlugin(
        'amadeusNext',
        'KundenDetail',
        [
            ClientController::class => 'detail',
        ],
        [
            ClientController::class => '',
        ]
    );
    
})();

