<?php
return [
	'ctrl' => [
        'label' => 'company',
		'title' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:client',
        'selicon_field' => 'logo',
        'typeicon_classes' => [
            'default' => 'case-client',
        ],
	],
	'columns' => [
		'company' => [
			'exclude' => false,
			'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:client.company',
			'required' => true,
			'config' => [
				'type' => 'input',
				'eval' => 'trim',
				'max' => '255',
				'behaviour' => [
					'allowLanguageSynchronization' => true,
				],
			]
		],
        'slug' => [
            'config' => [
                'type' => 'slug',
                'size' => 48,
                'generatorOptions' => [
                    'fields' => [
                        'company'
                    ],
                ],
                'fallbackCharacter' => '-',
                'eval' => 'uniqueInSite',
                'default' => '',
            ],
        ],
		'logo' => [
			'exclude' => true,
			'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:client.logo',
			'required' => true,
			'config' => [
                'type' => 'file',
                'maxitems' => 1,
                'allowed' => ['svg'],
                'overrideChildTca' => [
                    'types' => [
                        '0' => [
                            'showitem' => '
                                    --palette--;;imageoverlayPalette,
                                    --palette--;;filePalette'
                        ],
                        \TYPO3\CMS\Core\Resource\File::FILETYPE_IMAGE => [
								'showitem' => '
                                    --palette--;;imageoverlayPalette,
                                    --palette--;;filePalette'
                        ]
                    ],
                ],
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
		],
		'logowhite' => [
			'exclude' => true,
			'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:client.logowhite',
			'required' => true,
			'config' => [
                'type' => 'file',
                'maxitems' => 1,
                'allowed' => ['svg'],
                'overrideChildTca' => [
                    'types' => [
                        '0' => [
                            'showitem' => '
                                    --palette--;;imageoverlayPalette,
                                    --palette--;;filePalette'
                        ],
                        \TYPO3\CMS\Core\Resource\File::FILETYPE_IMAGE => [
                            'showitem' => '
                                    --palette--;;imageoverlayPalette,
                                    --palette--;;filePalette'
                        ]
                    ],
                ],
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
		],
        'description' => [
            'exclude' => false,
            'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:client.description',
            'required' => true,
            'config' => [
                'type' => 'text',
                'enableRichtext' => true,
                'behaviour' => [
                    'allowLanguageSynchronization' => true,
                ],
            ]
        ],
		'url' => [
			'exclude' => false,
			'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:client.url',
			'config' => [
				'type' => 'link',
				'allowedTypes' => 'url',
				'size' => 30,
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ],
			],
		],
        'business' => [
            'config' => [
                'type' => 'category'
            ],
        ],
        'nolink' => [
            'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:client.nolink.title',
            'description' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:client.nolink.description',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:client.nolink.label',
                    ],
                ],
            ],
        ],
	],
	'types' => [
        '0' => [
            'showitem' => 'company, nolink, slug, logo, logowhite, url, business, description'
        ]
    ]
];
