<?php
return [
    'ctrl' => [
        'label' => 'title',
        'title' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:award',
        'selicon_field' => 'logo',
        'typeicon_classes' => [
            'default' => 'award',
        ],
    ],
    'columns' => [
        'title' => [
            'exclude' => false,
            'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:award.title',
            'required' => true,
            'config' => [
                'type' => 'input',
                'eval' => 'trim',
                'max' => '255',
                'behaviour' => [
                    'allowLanguageSynchronization' => true,
                ],
            ]
        ],
        'logo' => [
            'exclude' => true,
            'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:award.logo',
            'required' => true,
            'config' => [
                'type' => 'file',
                'maxitems' => 1,
                'allowed' => ['svg'],
                'overrideChildTca' => [
                    'types' => [
                        '0' => [
                            'showitem' => '
                                    --palette--;;imageoverlayPalette,
                                    --palette--;;filePalette'
                        ],
                        \TYPO3\CMS\Core\Resource\File::FILETYPE_IMAGE => [
                            'showitem' => '
                                    --palette--;;imageoverlayPalette,
                                    --palette--;;filePalette'
                        ]
                    ],
                ],
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],
        'description' => [
            'exclude' => false,
            'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:award.description',
            'config' => [
                'type' => 'input',
                'eval' => 'trim',
                'max' => '255',
                'behaviour' => [
                    'allowLanguageSynchronization' => true,
                ],
            ]
        ],
        'project' => [
            'exclude' => false,
            'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:award.project',
            'config' => [
                'type' => 'group',
                'internal_type' => 'db',
                'allowed' => 'pages',
                'maxitems' => 1,
                'size' => 1,
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ],
            ],
        ],
        'url' => [
            'exclude' => false,
            'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:award.url',
            'config' => [
                'type' => 'link',
                'allowedTypes' => 'url',
                'size' => 30,
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ],
            ],
        ],
        'hidden' => [
            'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:visibility',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:hidden',
                    ],
                ],
            ],
        ],
        'importance' => [
            'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:award.importance',
            'config' => [
                'type' => 'number',
                'range' => [
                    'lower' => 0,
                    'upper' => 65535,
                ],
            ],
        ],
        'linkmode' => [
            'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:award.linkmode.title',
            'description' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:award.linkmode.description',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:award.linkmode.label',
                    ],
                ],
            ],
        ],
    ],
    'types' => [
        '0' => [
            'showitem' => 'title, hidden, logo, description, project, url, linkmode, importance'
        ]
    ]
];
