<?php

defined('TYPO3') or die('Access denied.');

use AmadeusAgentur\AmadeusNext\PageConfiguration;
use TYPO3\CMS\Core\Resource\File;
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;


$doktypesToAdd = [
    ['home', PageConfiguration::DOKTYPE_HOME, false],
    ['default', PageConfiguration::DOKTYPE_DEFAULT, false],
    ['fullwidth', PageConfiguration::DOKTYPE_CASE_FULLLWIDTH, false],
    ['case', PageConfiguration::DOKTYPE_CASE, true],
];

foreach ($doktypesToAdd as $item) {
    ExtensionManagementUtility::addTcaSelectItem(
        'pages',
        'doktype',
        [
            'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:pages.doktype.' . $item[0],
            'value' => $item[1],
            'icon' => $item[2] ? 'apps-pagetree-page-' . $item[0] : '',
            'group' => 'default',
        ]
    );
    $GLOBALS['TCA']['pages']['ctrl']['typeicon_classes'][$item[1]] = $item[2] ? 'apps-pagetree-page-' . $item[0] : 'apps-pagetree-page-default';
    $GLOBALS['TCA']['pages']['ctrl']['typeicon_classes'][$item[1] . '-hideinmenu'] = $item[2] ? 'apps-pagetree-page-' . $item[0] . '-hideinmenu' : 'apps-pagetree-page-hideinmenu';
    $GLOBALS['TCA']['pages']['ctrl']['typeicon_classes'][$item[1] . '-root'] = 'apps-pagetree-page-domain';
}

// we use the doktype configuration for default page "1" as a basis for our customization
// this is needed so we can manipulate the showitem configuration using \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addToAllTCAtypes
foreach ($doktypesToAdd as $doktype) {
    $GLOBALS['TCA']['pages']['types'][$doktype[1]]['showitem'] = $GLOBALS['TCA']['pages']['types'][1]['showitem'];
}


$case_fields = [
    'caseclient' => [
        'exclude' => false,
        'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:case.client',
        'required' => true,
        'config' => [
            'type' => 'group',
            'internal_type' => 'db',
            'allowed' => 'tx_amadeusnext_domain_model_client',
            'maxitems' => 1,
            'size' => 1,
            'behaviour' => [
                'allowLanguageSynchronization' => true
            ],
        ],
//        'config' => [
//            'type' => 'select',
//            'renderType' => 'selectSingle',
//            'foreign_table' => 'tx_amadeusnext_domain_model_client',
//            'fieldWizard' => [
//                'selectIcons' => [
//                    'disabled' => false,
//                ],
//            ],
//            'behaviour' => [
//                'allowLanguageSynchronization' => true
//            ],
//        ]
    ],
    'casecolor' => [
        'exclude' => false,
        'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:case.color',
        'required' => true,
        'config' => [
            'type' => 'color',
            'behaviour' => [
                'allowLanguageSynchronization' => true
            ],
        ]
    ],
    'casepremium' => [
        'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:case.premium.title',
        'description' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:case.premium.description',
        'config' => [
            'type' => 'check',
            'renderType' => 'checkboxToggle',
            'items' => [
                [
                    'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:case.premium.label',
                ],
            ]
        ],
    ],
    'casethumb' => [
        'exclude' => false,
        'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:case.thumb',
        'required' => true,
        'config' => [
            'type' => 'file',
            'maxitems' => 1,
            'allowed' => ['jpg', 'webp', 'avif'],
            'overrideChildTca' => [
                'types' => [
                    '0' => [
                        'showitem' => '
                                    --palette--;;imageoverlayPalette,
                                    --palette--;;filePalette'
                    ],
                    File::FILETYPE_IMAGE => [
                        'showitem' => '
                                    --palette--;;imageoverlayPalette,
                                    --palette--;;filePalette'
                    ]
                ],
            ],
            'behaviour' => [
                'allowLanguageSynchronization' => true
            ]
        ],
    ],
    'casevideo' => [
        'exclude' => false,
        'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:case.video',
        'config' => [
            'type' => 'file',
            'maxitems' => 1,
            'allowed' => ['mp4', 'mov', 'webm'],
            'behaviour' => [
                'allowLanguageSynchronization' => true
            ]
        ],
    ],
    'casedescription' => [
        'exclude' => false,
        'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:case.description',
        'required' => true,
        'config' => [
            'type' => 'text',
            'enableRichtext' => true,
            'fieldControl' => [
                'fullScreenRichtext' => [
                    'disabled' => false,
                ],
            ],
        ],
    ],
    'casestatement' => [
        'exclude' => false,
        'label' => 'LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:case.statement',
        'required' => true,
        'config' => [
            'type' => 'text',
            'enableRichtext' => true,
            'fieldControl' => [
                'fullScreenRichtext' => [
                    'disabled' => false,
                ],
            ],
        ],
    ],
];

ExtensionManagementUtility::addTCAcolumns(
    'pages',
    $case_fields
);

$GLOBALS['TCA']['pages']['palettes']['case_data'] = [
    'showitem' => 'caseclient,--linebreak--,casecolor'
];

$GLOBALS['TCA']['pages']['palettes']['case_content'] = [
    'showitem' => 'casevideo,casepremium,--linebreak--,casethumb,--linebreak--,casedescription,--linebreak--,casestatement'
];


// add case palettes to page properties for case doktype

ExtensionManagementUtility::addToAllTCAtypes(
    'pages',
    '--div--;LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:pages.doktype.case.data, --palette--;Case-Daten;case_data, --div--;LLL:EXT:amadeus_next/Resources/Private/Language/locallang_be.xlf:pages.doktype.case.content, --palette--;Case-Inhalt;case_content',
    PageConfiguration::DOKTYPE_CASE,
    'after:subtitle'
);
