<?php

declare(strict_types=1);

use TYPO3\CMS\Core\Security\ContentSecurityPolicy\Directive;
use TYPO3\CMS\Core\Security\ContentSecurityPolicy\HashType;
use TYPO3\CMS\Core\Security\ContentSecurityPolicy\HashValue;
use TYPO3\CMS\Core\Security\ContentSecurityPolicy\Mutation;
use TYPO3\CMS\Core\Security\ContentSecurityPolicy\MutationCollection;
use TYPO3\CMS\Core\Security\ContentSecurityPolicy\MutationMode;
use TYPO3\CMS\Core\Security\ContentSecurityPolicy\Scope;
use TYPO3\CMS\Core\Security\ContentSecurityPolicy\SourceKeyword;
use TYPO3\CMS\Core\Security\ContentSecurityPolicy\SourceScheme;
use TYPO3\CMS\Core\Security\ContentSecurityPolicy\UriValue;
use TYPO3\CMS\Core\Type\Map;


return Map::fromEntries([
    // Provide declarations for the frontend
    Scope::frontend(),
    new MutationCollection(
        new Mutation(
            MutationMode::Set,
            Directive::DefaultSrc,
            SourceKeyword::self, SourceKeyword::nonceProxy
        ),
        
        new Mutation(
            MutationMode::Extend,
            Directive::ImgSrc,
            SourceScheme::data,
            new UriValue('placehold.co'),
            new UriValue('https://www.google-analytics.com')
        ),
        
        new Mutation(
            MutationMode::Extend,
            Directive::ScriptSrc,
            new HashValue('Ly8GxLuPQMeWT09BDFStUeHGOD4rAstnf8ZxFm0f39Q=', HashType::sha256),
            new UriValue('https://www.googletagmanager.com')
        ),

        new Mutation(
            MutationMode::Extend,
            Directive::ConnectSrc,
            new UriValue('*.google-analytics.com')
        ),
        
        new Mutation(
            MutationMode::Extend,
            Directive::StyleSrc
        ),

        new Mutation(
            MutationMode::Extend,
            Directive::FrameSrc,
            new UriValue('https://www.googletagmanager.com')
        ),
    ),

], [
    // Provide declarations for the backend
    Scope::backend(),
    new MutationCollection(
        new Mutation(
            MutationMode::Extend,
            Directive::ImgSrc,
            new UriValue('*.unsplash.com')
        )
    )
]);
