<?php
namespace AmadeusAgentur\AmadeusNext\ViewHelpers;

use AmadeusAgentur\AmadeusNext\Domain\Repository\ClientRepository;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

final class ClientViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;
    private $clientRepo;


    public function injectClientRepository(ClientRepository $clientRepository): void {
        $this->clientRepo = $clientRepository;
    }

    public function initializeArguments(): void {
        // registerArgument($name, $type, $description, $required, $defaultValue, $escape)
        $this->registerArgument('clientId', 'int', 'ID of the client this case belongs to', true);
    }

    public function render() {
        return $this->clientRepo->findByUid($this->arguments['clientId']);
    }
}
