<?php

namespace AmadeusAgentur\AmadeusNext\Domain\Repository;

use TYPO3\CMS\Core\Database\Connection;
use TYPO3\CMS\Core\Database\ConnectionPool;

final class PageRepository {

    public function __construct(
        private readonly ConnectionPool $connectionPool
    ) {}

    public function findAllCases(int $limit, bool $premium, string $sort): array {
        $queryBuilder = $this->connectionPool->getQueryBuilderForTable('pages');

        $queryBuilder
            ->select('*')
            ->from('pages');

        if ($premium) {
            $queryBuilder
                ->where(
                    $queryBuilder->expr()->eq('doktype', $queryBuilder->createNamedParameter(119, Connection::PARAM_INT)),
                    $queryBuilder->expr()->eq('casepremium', $queryBuilder->createNamedParameter(1, Connection::PARAM_INT))
                );
        }
        else {
            $queryBuilder
                ->where(
                    $queryBuilder->expr()->eq('doktype', $queryBuilder->createNamedParameter(119, Connection::PARAM_INT))
                );
        }

        if ($sort != '') {
            $queryBuilder
                ->orderBy('uid', $sort);
        }

        return $queryBuilder
            ->setMaxResults($limit)
            ->executeQuery()
            ->fetchAllAssociative();
    }

    public function findCasesByClient(int $client): array {
        $queryBuilder = $this->connectionPool->getQueryBuilderForTable('pages');

        return $queryBuilder
            ->select('*')
            ->from('pages')
            ->where(
                $queryBuilder->expr()->eq('doktype', $queryBuilder->createNamedParameter(119, Connection::PARAM_INT)),
                $queryBuilder->expr()->eq('caseclient', $queryBuilder->createNamedParameter($client))
            )
            ->orderBy('uid', 'DESC')
            ->executeQuery()
            ->fetchAllAssociative();
    }
}