<?php

namespace AmadeusAgentur\AmadeusNext\Domain\Repository;

use TYPO3\CMS\Extbase\Persistence\Repository;
use TYPO3\CMS\Extbase\Persistence\QueryResultInterface;

class ClientRepository extends Repository {
    public function findClientsByAmount(int $amt, string $sort = ''): QueryResultInterface {
        $query = $this->createQuery();

        if ($sort == 'DESC') {
            $query->setOrderings([
                'uid' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_DESCENDING
            ]);
        }

        $query->setLimit($amt);

        return $query->execute();
    }
}