<?php

declare(strict_types=1);

namespace AmadeusAgentur\AmadeusNext\Domain\Repository;

use TYPO3\CMS\Core\Database\Connection;
use TYPO3\CMS\Core\Database\ConnectionPool;


final class CategoryRepository {
    public function __construct(
        private readonly ConnectionPool $connectionPool
    ) {}

    public function findAllBusinesses(int $parentId, string $sort): array {
        $queryBuilder = $this->connectionPool->getQueryBuilderForTable('sys_category');

        $queryBuilder
            ->select('title', 'uid')
            ->from('sys_category');

        $queryBuilder
            ->where(
                $queryBuilder->expr()->eq('parent', $parentId)
            );

        if ($sort != '') {
            $queryBuilder
                ->orderBy('title', $sort);
        }

        return $queryBuilder
            ->executeQuery()
            ->fetchAllAssociative();
    }

    public function findSingleBusiness(int $catId): array {
        $queryBuilder = $this->connectionPool->getQueryBuilderForTable('sys_category');

        $queryBuilder
            ->select('*')
            ->from('sys_category');

        $queryBuilder
            ->where(
                $queryBuilder->expr()->eq('uid', $catId)
            );

        return $queryBuilder
            ->executeQuery()
            ->fetchAllAssociative();
    }
}