<?php

namespace AmadeusAgentur\AmadeusNext\Domain\Model;

use \TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class Client extends AbstractEntity {
    protected string $company = '';
    protected string $description = '';
    protected int $logo = 0;
    protected int $logowhite = 0;
    protected string $url = '';
    protected int $business = 0;
    protected bool $nolink = false;
    protected string $slug = '';

    public function __construct(string $company, string $description, int $logo, int $logowhite, string $url, int $business, bool $nolink, string $slug) {
        $this->setCompany($company);
        $this->setDescription($description);
        $this->setLogo($logo);
        $this->setLogowhite($logowhite);
        $this->setUrl($url);
        $this->setBusiness($business);
        $this->setNoLink($nolink);
        $this->setSlug($slug);
    }

    public function setCompany(string $input): void {
        $this->company = $input;
    }

    public function getCompany(): string {
        return $this->company;
    }

    public function setDescription(string $input): void {
        $this->description = $input;
    }

    public function getDescription(): string {
        return $this->description;
    }

    public function setLogo(int $input): void {
        $this->logo = $input;
    }

    public function getLogo(): int {
        return $this->logo;
    }

    public function setLogowhite(int $input): void {
        $this->logowhite = $input;
    }

    public function getLogowhite(): int {
        return $this->logowhite;
    }

    public function setUrl(string $input): void {
        $this->url = $input;
    }

    public function getUrl(): string {
        return $this->url;
    }

    public function setBusiness(int $input): void {
        $this->business = $input;
    }

    public function getBusiness(): int {
        return $this->business;
    }

    public function setNoLink(bool $input): void {
        $this->nolink = $input;
    }

    public function getNoLink(): bool {
        return $this->nolink;
    }

    public function setSlug(string $input): void {
        $this->slug = $input;
    }

    public function getSlug(): string {
        return $this->slug;
    }
}
