<?php

namespace AmadeusAgentur\AmadeusNext\Domain\Model;

use \TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class Award extends AbstractEntity
{
    protected string $title = '';
    protected string $description = '';
    protected int $logo = 0;
    protected int $project = 0;
    protected string $url = '';
    protected bool $hidden = false;
    protected int $importance = 10;
    protected bool $linkmode = false;

    public function __construct(string $title, string $description, int $logo, int $project, string $url, bool $linkmode, bool $hidden) {
        $this->setTitle($title);
        $this->setDescription($description);
        $this->setLogo($logo);
        $this->setProject($project);
        $this->setUrl($url);
        $this->setLinkmode($linkmode);
        $this->setHidden($hidden);
    }

    public function setTitle(string $input): void {
        $this->title = $input;
    }

    public function getTitle(): string {
        return $this->title;
    }

    public function setDescription(string $input): void {
        $this->description = $input;
    }

    public function getDescription(): string {
        return $this->description;
    }

    public function setLogo(int $input): void {
        $this->logo = $input;
    }

    public function getLogo(): string {
        return $this->logo;
    }

    public function setProject(int $input): void {
        $this->project = $input;
    }

    public function getProject(): string {
        return $this->project;
    }

    public function setUrl(string $input): void {
        $this->url = $input;
    }

    public function getUrl(): string {
        return $this->url;
    }

    public function setHidden(bool $input): void {
        $this->hidden = $input;
    }

    public function getHidden(): bool {
        return $this->hidden;
    }

    public function setImportance(int $input): void {
        $this->importance = $input;
    }

    public function getImportance(): int {
        return $this->importance;
    }

    public function setLinkmode(bool $input): void {
        $this->linkmode = $input;
    }

    public function getLinkmode(): bool {
        return $this->linkmode;
    }
}