<?php


namespace AmadeusAgentur\AmadeusNext\Controller;

use AmadeusAgentur\AmadeusNext\Domain\Repository\CategoryRepository;
use AmadeusAgentur\AmadeusNext\Domain\Repository\ClientRepository;
use AmadeusAgentur\AmadeusNext\Domain\Repository\PageRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Frontend\Category\Collection\CategoryCollection;
use Psr\Http\Message\ResponseInterface;


class ClientController extends ActionController {

    private $categoryRepo;
    private $clientRepo;
    private $pageRepo;
    protected $args = array();

    public function injectCategoryRepository(CategoryRepository $categoryRepository): void {
        $this->categoryRepo = $categoryRepository;
    }

    public function injectClientRepository(ClientRepository $clientRepository): void {
        $this->clientRepo = $clientRepository;
    }

    public function injectPageRepository(PageRepository $pageRepository): void {
        $this->pageRepo = $pageRepository;
    }

    public function amountAction(): ResponseInterface {
//        $context = GeneralUtility::makeInstance(Context::class);
//        $langId = $context->getPropertyFromAspect('language', 'id');
        switch ($this->settings['searchMode']) {
            case 1:
                $rawResults = $this->clientRepo->findAll();

                if ($this->settings['searchAmount'] < count($rawResults)) {
                    $range = range(0, count($rawResults) - 1);
                    shuffle($range);
                    $rand_ids = array_slice($range, 0 , $this->settings['searchAmount']);

                    for ($i = 0; $i < $this->settings['searchAmount']; $i++) {
                        $results[] = $rawResults[$rand_ids[$i]];
                    }
                }
                else {
                    $results = $rawResults;
                }

                break;
            default:
                $results = $this->clientRepo->findClientsByAmount($this->settings['searchAmount'], 'DESC');
                break;
        }

        $amount = count($results);
        $gridSuggestion = 2;

        while ($amount > sqrt($gridSuggestion) && $gridSuggestion < 5) {
            $gridSuggestion++;
        }

        if (($gridSuggestion - 1) == 1) {
            $gridSuggestion = 2;
        }
        else {
            $gridSuggestion--;
        }

        $this->view->assign('clients', $results);
        $this->view->assign('gapSize', round(24/($gridSuggestion - 1)));
        $this->view->assign('gridSize', $gridSuggestion);

        return $this->htmlResponse();
    }

    public function categoryAction(int $cat = -1): ResponseInterface {
        if ($cat == -1) {
            $catId = $this->settings['displayCategory'];
        } else {
            $catId = $cat;
        }

        $collection = CategoryCollection::load(
            $catId,
            true,
            'tx_amadeusnext_domain_model_client',
            'business'
        );

        $results = match ($this->settings['order']) {
            '1' => array_reverse($collection->getItems()),
            default => $collection->getItems(),
        };

        if ($this->settings['order'] == 2) {
            shuffle($results);
        }

        $amount = count($results);
        $gridSuggestion = 2;

        while ($amount > sqrt($gridSuggestion) && $gridSuggestion < 5) {
            $gridSuggestion++;
        }

        if (($gridSuggestion - 1) == 1) {
            $gridSuggestion = 2;
        }
        else {
            $gridSuggestion--;
        }

        $this->view->assign('clients', array_slice($results, 0, $this->settings['displayLimit']));
        $this->view->assign('gapSize', round(24/($gridSuggestion - 1)));
        $this->view->assign('gridSize', $gridSuggestion);

        return $this->htmlResponse();
    }

    public function selectionAction(): ResponseInterface {
//        $context = GeneralUtility::makeInstance(Context::class);
//        $langId = $context->getPropertyFromAspect('language', 'id');
        $amount = 0;
        $cids = explode(',', $this->settings['searchClients']);
        $gridSuggestion = 2;
        $results = array();

        foreach ($cids as $client) {
            $results[] = $this->clientRepo->findByUid((int) $client);
            $amount++;
        }

        while ($amount > sqrt($gridSuggestion) && $gridSuggestion < 5) {
            $gridSuggestion++;
        }

        if (($gridSuggestion - 1) == 1) {
            $gridSuggestion = 2;
        }
        else {
            $gridSuggestion--;
        }

        $this->view->assign('clients', $results);
        $this->view->assign('gapSize', round(24/($gridSuggestion - 1)));
        $this->view->assign('gridSize', $gridSuggestion);

        return $this->htmlResponse();
    }

    public function detailAction(int $clientId): ResponseInterface {
        $clientcases = $this->pageRepo->findCasesByClient($clientId);
        $clientdata = $this->clientRepo->findByUid($clientId);

        $this->view->assign('cases', $clientcases);
        $this->view->assign('client', $clientdata);

        return $this->htmlResponse();
    }
}