<?php


namespace AmadeusAgentur\AmadeusNext\Controller;

use AmadeusAgentur\AmadeusNext\Domain\Repository\CategoryRepository;
use AmadeusAgentur\AmadeusNext\Domain\Repository\PageRepository;
use TYPO3\CMS\Core\Pagination\ArrayPaginator;
use TYPO3\CMS\Core\Pagination\SlidingWindowPagination;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Frontend\Category\Collection\CategoryCollection;
use Psr\Http\Message\ResponseInterface;


class CaseController extends ActionController {

    private $categoryRepo;
    private $pageRepo;

    public function injectCategoryRepository(CategoryRepository $categoryRepository): void {
        $this->categoryRepo = $categoryRepository;
    }

    public function injectPageRepository(PageRepository $pageRepository): void {
        $this->pageRepo = $pageRepository;
    }

    public function amountAction(): ResponseInterface {
        $rawResults = array();

        switch ($this->settings['source']) {
            case 0:
                $rawResults = $this->pageRepo->findAllCases($this->settings['displayLimit'], false, 'DESC');
                break;
            case 1:
                $rawResults = $this->pageRepo->findAllCases($this->settings['displayLimit'], true, 'DESC');
                break;
            case 2:
                $rawResults = $this->pageRepo->findAllCases(65535, false, '');
                break;
            case 3:
                $rawResults = $this->pageRepo->findAllCases(65535, true, '');
                break;
        }

        if (in_array($this->settings['source'], [2,3]) and $this->settings['displayLimit'] < count($rawResults)) {
            $range = range(0, count($rawResults) - 1);
            shuffle($range);
            $rand_ids = array_slice($range, 0 , $this->settings['displayLimit']);

            for ($i = 0; $i < $this->settings['displayLimit']; $i++) {
                $results[] = $rawResults[$rand_ids[$i]];
            }
        }
        else {
            $results = $rawResults;
        }

        if ($this->settings['displayLimit'] > $this->settings['paginationTreshold'] and count($results) > $this->settings['paginationTreshold']) {
            $paginator = new ArrayPaginator($results, 1, $this->settings['paginationTreshold']);
            $pagination = new SlidingWindowPagination($paginator, $this->settings['paginationLinks']);

            $this->view->assign('cases_paginated', ['pagination' => $pagination, 'paginator' => $paginator]);
        }

        $this->view->assign('cases', $results);

        return $this->htmlResponse();
    }

    public function categoryAction(int $cat = -1): ResponseInterface {
        if ($cat == -1) {
            $catId = $this->settings['displayCategory'];
        } else {
            $catId = $cat;
        }

        $collection = CategoryCollection::load(
            $catId,
            true,
            'pages',
            'categories'
        );

        $results = match ($this->settings['order']) {
            '1' => array_reverse($collection->getItems()),
            default => $collection->getItems(),
        };

        if ($this->settings['order'] == 2) {
            shuffle($results);
        }

        $this->view->assign('cases', $results);

        return $this->htmlResponse();
    }

    public function selectionAction(): ResponseInterface {
        $cids = explode(',', $this->settings['displayCases']);
        $results = array();

        foreach ($cids as $case) {
            $object = \TYPO3\CMS\Backend\Utility\BackendUtility::getRecord('pages', $case);

            if ($object['doktype'] == 119) {
                $results[] = $object;
            }
        }

        $this->view->assign('cases', $results);

        return $this->htmlResponse();
    }
}