<?php


namespace AmadeusAgentur\AmadeusNext\Controller;

use AmadeusAgentur\AmadeusNext\Domain\Repository\CategoryRepository;
use AmadeusAgentur\AmadeusNext\Domain\Repository\ClientRepository;
use AmadeusAgentur\AmadeusNext\Domain\Repository\PageRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Frontend\Category\Collection\CategoryCollection;
use Psr\Http\Message\ResponseInterface;


class BusinessController extends ActionController
{
    private $categoryRepo;

    public function injectCategoryRepository(CategoryRepository $categoryRepository): void {
        $this->categoryRepo = $categoryRepository;
    }

    public function detailAction(int $businessId): ResponseInterface {
        $business = $this->categoryRepo->findSingleBusiness($businessId);

        $collection = CategoryCollection::load(
            $businessId,
            true,
            'tx_amadeusnext_domain_model_client',
            'business'
        );

        $amount = $collection->count();
        $gridSuggestion = 2;

        while ($amount > sqrt($gridSuggestion) && $gridSuggestion < 5) {
            $gridSuggestion++;
        }

        if (($gridSuggestion - 1) == 1) {
            $gridSuggestion = 2;
        }
        else {
            $gridSuggestion--;
        }

        //$this->view->assign('cases', $clientcases);
        $this->view->assign('clients', $collection->getItems());
        $this->view->assign('business', $business[0]);
        $this->view->assign('gapSize', round(24/($gridSuggestion - 1)));
        $this->view->assign('gridSize', $gridSuggestion);

        return $this->htmlResponse();
    }
}