<?php


namespace AmadeusAgentur\AmadeusNext\Controller;

use AmadeusAgentur\AmadeusNext\Domain\Repository\AwardRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use Psr\Http\Message\ResponseInterface;


class AwardController extends ActionController {

    private $awardRepo;

    public function injectAwardRepository(AwardRepository $awardRepository): void {
        $this->awardRepo = $awardRepository;
    }

    public function amountAction(): ResponseInterface {
        $results = $this->awardRepo->findAwardsByAmount($this->settings['displayLimit']);

        $this->view->assign('awards', $results);

        return $this->htmlResponse();
    }

    public function selectionAction(): ResponseInterface {
        $aids = explode(',', $this->settings['searchAwards']);
        $results = array();

        foreach ($aids as $award) {
            $results[] = $this->awardRepo->findByUid((int) $award);
        }

        $this->view->assign('awards', $results);

        return $this->htmlResponse();
    }
}